@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *  /*
 * Defines how resources deployed by the deployment stack are locked.
 * @property applyToChildScopes DenySettings will be applied to child scopes.
 * @property excludedActions List of role-based management operations that are excluded from the denySettings. Up to 200 actions are permitted. If the denySetting mode is set to 'denyWriteAndDelete', then the following actions are automatically appended to 'excludedActions': '*/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting mode is set to 'denyDelete', then the following actions are automatically appended to 'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
 * @property excludedPrincipals List of AAD principal IDs excluded from the lock. Up to 5 principals are permitted.
 * @property mode denySettings Mode.
 */
public data class DenySettingsResponse(
    public val applyToChildScopes: Boolean? = null,
    public val excludedActions: List<String>? = null,
    public val excludedPrincipals: List<String>? = null,
    public val mode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.DenySettingsResponse):
            DenySettingsResponse = DenySettingsResponse(
            applyToChildScopes = javaType.applyToChildScopes().map({ args0 -> args0 }).orElse(null),
            excludedActions = javaType.excludedActions().map({ args0 -> args0 }),
            excludedPrincipals = javaType.excludedPrincipals().map({ args0 -> args0 }),
            mode = javaType.mode(),
        )
    }
}
