@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Deployment dependency information.
 * @property dependsOn The list of dependencies.
 * @property id The ID of the dependency.
 * @property resourceName The dependency resource name.
 * @property resourceType The dependency resource type.
 */
public data class DependencyResponse(
    public val dependsOn: List<BasicDependencyResponse>? = null,
    public val id: String? = null,
    public val resourceName: String? = null,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.DependencyResponse):
            DependencyResponse = DependencyResponse(
            dependsOn = javaType.dependsOn().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.BasicDependencyResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
