@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The debug setting.
 * @property detailLevel Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information that is being passed in during deployment. By logging information about the request or response, sensitive data that is retrieved through the deployment operations could potentially be exposed.
 */
public data class DeploymentStacksDebugSettingResponse(
    public val detailLevel: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.DeploymentStacksDebugSettingResponse):
            DeploymentStacksDebugSettingResponse = DeploymentStacksDebugSettingResponse(
            detailLevel = javaType.detailLevel().map({ args0 -> args0 }).orElse(null),
        )
    }
}
