@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The resource Id extended model.
 * @property error Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
 * @property id The resourceId of a resource managed by the deployment stack.
 */
public data class ResourceReferenceExtendedResponse(
    public val error: ErrorResponseResponse? = null,
    public val id: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ResourceReferenceExtendedResponse):
            ResourceReferenceExtendedResponse = ResourceReferenceExtendedResponse(
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
        )
    }
}
