@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin

import com.pulumi.azurenative.saas.SaasFunctions.getSaasSubscriptionLevelPlain
import com.pulumi.azurenative.saas.SaasFunctions.listSaasResourceAccessTokenPlain
import com.pulumi.azurenative.saas.SaasFunctions.listSaasSubscriptionLevelAccessTokenPlain
import com.pulumi.azurenative.saas.kotlin.inputs.GetSaasSubscriptionLevelPlainArgs
import com.pulumi.azurenative.saas.kotlin.inputs.GetSaasSubscriptionLevelPlainArgsBuilder
import com.pulumi.azurenative.saas.kotlin.inputs.ListSaasResourceAccessTokenPlainArgs
import com.pulumi.azurenative.saas.kotlin.inputs.ListSaasResourceAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.saas.kotlin.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgs
import com.pulumi.azurenative.saas.kotlin.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.saas.kotlin.outputs.GetSaasSubscriptionLevelResult
import com.pulumi.azurenative.saas.kotlin.outputs.ListSaasResourceAccessTokenResult
import com.pulumi.azurenative.saas.kotlin.outputs.ListSaasSubscriptionLevelAccessTokenResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.saas.kotlin.outputs.GetSaasSubscriptionLevelResult.Companion.toKotlin as getSaasSubscriptionLevelResultToKotlin
import com.pulumi.azurenative.saas.kotlin.outputs.ListSaasResourceAccessTokenResult.Companion.toKotlin as listSaasResourceAccessTokenResultToKotlin
import com.pulumi.azurenative.saas.kotlin.outputs.ListSaasSubscriptionLevelAccessTokenResult.Companion.toKotlin as listSaasSubscriptionLevelAccessTokenResultToKotlin

public object SaasFunctions {
    /**
     * Gets information about the specified Subscription Level SaaS.
     * Azure REST API version: 2018-03-01-beta.
     * @param argument null
     * @return SaaS REST API resource definition.
     */
    public suspend fun getSaasSubscriptionLevel(argument: GetSaasSubscriptionLevelPlainArgs):
        GetSaasSubscriptionLevelResult =
        getSaasSubscriptionLevelResultToKotlin(getSaasSubscriptionLevelPlain(argument.toJava()).await())

    /**
     * @see [getSaasSubscriptionLevel].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the resource.
     * @return SaaS REST API resource definition.
     */
    public suspend fun getSaasSubscriptionLevel(resourceGroupName: String, resourceName: String):
        GetSaasSubscriptionLevelResult {
        val argument = GetSaasSubscriptionLevelPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getSaasSubscriptionLevelResultToKotlin(getSaasSubscriptionLevelPlain(argument.toJava()).await())
    }

    /**
     * @see [getSaasSubscriptionLevel].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;saas&#46;kotlin&#46;inputs&#46;GetSaasSubscriptionLevelPlainArgs].
     * @return SaaS REST API resource definition.
     */
    public suspend
    fun getSaasSubscriptionLevel(argument: suspend GetSaasSubscriptionLevelPlainArgsBuilder.() -> Unit):
        GetSaasSubscriptionLevelResult {
        val builder = GetSaasSubscriptionLevelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSaasSubscriptionLevelResultToKotlin(getSaasSubscriptionLevelPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the ISV access token for a SaaS resource.
     * Azure REST API version: 2018-03-01-beta.
     * @param argument null
     * @return the ISV access token result response.
     */
    public suspend fun listSaasResourceAccessToken(argument: ListSaasResourceAccessTokenPlainArgs):
        ListSaasResourceAccessTokenResult =
        listSaasResourceAccessTokenResultToKotlin(listSaasResourceAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [listSaasResourceAccessToken].
     * @param resourceId The Saas resource ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000)
     * @return the ISV access token result response.
     */
    public suspend fun listSaasResourceAccessToken(resourceId: String):
        ListSaasResourceAccessTokenResult {
        val argument = ListSaasResourceAccessTokenPlainArgs(
            resourceId = resourceId,
        )
        return listSaasResourceAccessTokenResultToKotlin(listSaasResourceAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [listSaasResourceAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;saas&#46;kotlin&#46;inputs&#46;ListSaasResourceAccessTokenPlainArgs].
     * @return the ISV access token result response.
     */
    public suspend
    fun listSaasResourceAccessToken(argument: suspend ListSaasResourceAccessTokenPlainArgsBuilder.() -> Unit):
        ListSaasResourceAccessTokenResult {
        val builder = ListSaasResourceAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSaasResourceAccessTokenResultToKotlin(listSaasResourceAccessTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the ISV access token for a specified Subscription Level SaaS.
     * Azure REST API version: 2018-03-01-beta.
     * @param argument null
     * @return the ISV access token result response.
     */
    public suspend
    fun listSaasSubscriptionLevelAccessToken(argument: ListSaasSubscriptionLevelAccessTokenPlainArgs):
        ListSaasSubscriptionLevelAccessTokenResult =
        listSaasSubscriptionLevelAccessTokenResultToKotlin(listSaasSubscriptionLevelAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [listSaasSubscriptionLevelAccessToken].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the resource.
     * @return the ISV access token result response.
     */
    public suspend fun listSaasSubscriptionLevelAccessToken(
        resourceGroupName: String,
        resourceName: String,
    ): ListSaasSubscriptionLevelAccessTokenResult {
        val argument = ListSaasSubscriptionLevelAccessTokenPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return listSaasSubscriptionLevelAccessTokenResultToKotlin(listSaasSubscriptionLevelAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [listSaasSubscriptionLevelAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;saas&#46;kotlin&#46;inputs&#46;ListSaasSubscriptionLevelAccessTokenPlainArgs].
     * @return the ISV access token result response.
     */
    public suspend
    fun listSaasSubscriptionLevelAccessToken(argument: suspend ListSaasSubscriptionLevelAccessTokenPlainArgsBuilder.() -> Unit):
        ListSaasSubscriptionLevelAccessTokenResult {
        val builder = ListSaasSubscriptionLevelAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listSaasSubscriptionLevelAccessTokenResultToKotlin(listSaasSubscriptionLevelAccessTokenPlain(builtArgument.toJava()).await())
    }
}
