@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * saas properties
 * @property autoRenew Whether the SaaS subscription will auto renew upon term end.
 * @property created The created date of this resource.
 * @property isFreeTrial Whether the current term is a Free Trial term
 * @property lastModified The last modifier date if this resource.
 * @property offerId The offer id.
 * @property paymentChannelMetadata The metadata about the SaaS subscription such as the AzureSubscriptionId and ResourceUri.
 * @property paymentChannelType The Payment channel for the SaasSubscription.
 * @property publisherId The publisher id.
 * @property publisherTestEnvironment The environment in the publisher side for this resource.
 * @property quantity The seat count.
 * @property saasResourceName The SaaS resource name.
 * @property saasSessionId The saas session id used for dev service migration request.
 * @property saasSubscriptionId The saas subscription id used for tenant to subscription level migration request.
 * @property skuId The plan id.
 * @property status The SaaS Subscription Status.
 * @property term The current Term object.
 * @property termId The current Term id.
 */
public data class SaasResourceResponseProperties(
    public val autoRenew: Boolean? = null,
    public val created: String,
    public val isFreeTrial: Boolean? = null,
    public val lastModified: String? = null,
    public val offerId: String? = null,
    public val paymentChannelMetadata: Map<String, String>? = null,
    public val paymentChannelType: String? = null,
    public val publisherId: String? = null,
    public val publisherTestEnvironment: String? = null,
    public val quantity: Double? = null,
    public val saasResourceName: String? = null,
    public val saasSessionId: String? = null,
    public val saasSubscriptionId: String? = null,
    public val skuId: String? = null,
    public val status: String? = null,
    public val term: SaasPropertiesResponseTerm? = null,
    public val termId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.saas.outputs.SaasResourceResponseProperties):
            SaasResourceResponseProperties = SaasResourceResponseProperties(
            autoRenew = javaType.autoRenew().map({ args0 -> args0 }).orElse(null),
            created = javaType.created(),
            isFreeTrial = javaType.isFreeTrial().map({ args0 -> args0 }).orElse(null),
            lastModified = javaType.lastModified().map({ args0 -> args0 }).orElse(null),
            offerId = javaType.offerId().map({ args0 -> args0 }).orElse(null),
            paymentChannelMetadata = javaType.paymentChannelMetadata().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            paymentChannelType = javaType.paymentChannelType().map({ args0 -> args0 }).orElse(null),
            publisherId = javaType.publisherId().map({ args0 -> args0 }).orElse(null),
            publisherTestEnvironment = javaType.publisherTestEnvironment().map({ args0 -> args0 }).orElse(null),
            quantity = javaType.quantity().map({ args0 -> args0 }).orElse(null),
            saasResourceName = javaType.saasResourceName().map({ args0 -> args0 }).orElse(null),
            saasSessionId = javaType.saasSessionId().map({ args0 -> args0 }).orElse(null),
            saasSubscriptionId = javaType.saasSubscriptionId().map({ args0 -> args0 }).orElse(null),
            skuId = javaType.skuId().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            term = javaType.term().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.saas.kotlin.outputs.SaasPropertiesResponseTerm.Companion.toKotlin(args0)
                })
            }).orElse(null),
            termId = javaType.termId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
