@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin

import com.pulumi.azurenative.scheduler.JobCollectionArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.inputs.JobCollectionPropertiesArgs
import com.pulumi.azurenative.scheduler.kotlin.inputs.JobCollectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scheduler:JobCollection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}
 * ```
 * @property jobCollectionName The job collection name.
 * @property location Gets or sets the storage account location.
 * @property name Gets or sets the job collection resource name.
 * @property properties Gets or sets the job collection properties.
 * @property resourceGroupName The resource group name.
 * @property tags Gets or sets the tags.
 */
public data class JobCollectionArgs(
    public val jobCollectionName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<JobCollectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.JobCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.JobCollectionArgs =
        com.pulumi.azurenative.scheduler.JobCollectionArgs.builder()
            .jobCollectionName(jobCollectionName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [JobCollectionArgs].
 */
@PulumiTagMarker
public class JobCollectionArgsBuilder internal constructor() {
    private var jobCollectionName: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<JobCollectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The job collection name.
     */
    @JvmName("ieaabcdhvpahiqxn")
    public suspend fun jobCollectionName(`value`: Output<String>) {
        this.jobCollectionName = value
    }

    /**
     * @param value Gets or sets the storage account location.
     */
    @JvmName("wuhhgrytkdatbcjx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Gets or sets the job collection resource name.
     */
    @JvmName("yrkktxkxetslnmpv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the job collection properties.
     */
    @JvmName("eqqybdewjoijgane")
    public suspend fun properties(`value`: Output<JobCollectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eestbgchfutahjnq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the tags.
     */
    @JvmName("wurmkxylfeevclaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The job collection name.
     */
    @JvmName("yvuedejdktkbbdig")
    public suspend fun jobCollectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobCollectionName = mapped
    }

    /**
     * @param value Gets or sets the storage account location.
     */
    @JvmName("vceyjfmteimrjtay")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Gets or sets the job collection resource name.
     */
    @JvmName("lshpawjrxfntxcca")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the job collection properties.
     */
    @JvmName("oiskkjqquhtufqns")
    public suspend fun properties(`value`: JobCollectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the job collection properties.
     */
    @JvmName("glhkqibpshfrgfhs")
    public suspend fun properties(argument: suspend JobCollectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = JobCollectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("nyevnwlborsfoosh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the tags.
     */
    @JvmName("bgavmeorhxplvtcy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the tags.
     */
    @JvmName("lnqunrmsdrqdxxab")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): JobCollectionArgs = JobCollectionArgs(
        jobCollectionName = jobCollectionName,
        location = location,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
