@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin

import com.pulumi.azurenative.scheduler.SchedulerFunctions.getJobCollectionPlain
import com.pulumi.azurenative.scheduler.SchedulerFunctions.getJobPlain
import com.pulumi.azurenative.scheduler.kotlin.inputs.GetJobCollectionPlainArgs
import com.pulumi.azurenative.scheduler.kotlin.inputs.GetJobCollectionPlainArgsBuilder
import com.pulumi.azurenative.scheduler.kotlin.inputs.GetJobPlainArgs
import com.pulumi.azurenative.scheduler.kotlin.inputs.GetJobPlainArgsBuilder
import com.pulumi.azurenative.scheduler.kotlin.outputs.GetJobCollectionResult
import com.pulumi.azurenative.scheduler.kotlin.outputs.GetJobResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.scheduler.kotlin.outputs.GetJobCollectionResult.Companion.toKotlin as getJobCollectionResultToKotlin
import com.pulumi.azurenative.scheduler.kotlin.outputs.GetJobResult.Companion.toKotlin as getJobResultToKotlin

public object SchedulerFunctions {
    /**
     * Gets a job.
     * Azure REST API version: 2016-03-01.
     * @param argument null
     * @return null
     */
    public suspend fun getJob(argument: GetJobPlainArgs): GetJobResult =
        getJobResultToKotlin(getJobPlain(argument.toJava()).await())

    /**
     * @see [getJob].
     * @param jobCollectionName The job collection name.
     * @param jobName The job name.
     * @param resourceGroupName The resource group name.
     * @return null
     */
    public suspend fun getJob(
        jobCollectionName: String,
        jobName: String,
        resourceGroupName: String,
    ): GetJobResult {
        val argument = GetJobPlainArgs(
            jobCollectionName = jobCollectionName,
            jobName = jobName,
            resourceGroupName = resourceGroupName,
        )
        return getJobResultToKotlin(getJobPlain(argument.toJava()).await())
    }

    /**
     * @see [getJob].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scheduler&#46;kotlin&#46;inputs&#46;GetJobPlainArgs].
     * @return null
     */
    public suspend fun getJob(argument: suspend GetJobPlainArgsBuilder.() -> Unit): GetJobResult {
        val builder = GetJobPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobResultToKotlin(getJobPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a job collection.
     * Azure REST API version: 2016-03-01.
     * @param argument null
     * @return null
     */
    public suspend fun getJobCollection(argument: GetJobCollectionPlainArgs): GetJobCollectionResult =
        getJobCollectionResultToKotlin(getJobCollectionPlain(argument.toJava()).await())

    /**
     * @see [getJobCollection].
     * @param jobCollectionName The job collection name.
     * @param resourceGroupName The resource group name.
     * @return null
     */
    public suspend fun getJobCollection(jobCollectionName: String, resourceGroupName: String):
        GetJobCollectionResult {
        val argument = GetJobCollectionPlainArgs(
            jobCollectionName = jobCollectionName,
            resourceGroupName = resourceGroupName,
        )
        return getJobCollectionResultToKotlin(getJobCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getJobCollection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;scheduler&#46;kotlin&#46;inputs&#46;GetJobCollectionPlainArgs].
     * @return null
     */
    public suspend
    fun getJobCollection(argument: suspend GetJobCollectionPlainArgsBuilder.() -> Unit):
        GetJobCollectionResult {
        val builder = GetJobCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getJobCollectionResultToKotlin(getJobCollectionPlain(builtArgument.toJava()).await())
    }
}
