@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or set the job state.
 */
public enum class JobState(
    public val javaValue: com.pulumi.azurenative.scheduler.enums.JobState,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.enums.JobState> {
    Enabled(com.pulumi.azurenative.scheduler.enums.JobState.Enabled),
    Disabled(com.pulumi.azurenative.scheduler.enums.JobState.Disabled),
    Faulted(com.pulumi.azurenative.scheduler.enums.JobState.Faulted),
    Completed(com.pulumi.azurenative.scheduler.enums.JobState.Completed),
    ;

    override fun toJava(): com.pulumi.azurenative.scheduler.enums.JobState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.enums.JobState): JobState =
            JobState.values().first { it.javaValue == javaType }
    }
}
