@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.BasicAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property password Gets or sets the password, return value will always be empty.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'Basic'.
 * @property username Gets or sets the username.
 */
public data class BasicAuthenticationArgs(
    public val password: Output<String>? = null,
    public val type: Output<String>,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.BasicAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.BasicAuthenticationArgs =
        com.pulumi.azurenative.scheduler.inputs.BasicAuthenticationArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BasicAuthenticationArgs].
 */
@PulumiTagMarker
public class BasicAuthenticationArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var type: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value Gets or sets the password, return value will always be empty.
     */
    @JvmName("mylfmxcwlcmwnwrb")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'Basic'.
     */
    @JvmName("rvofmnipwahijnsn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the username.
     */
    @JvmName("hrhaupdtqgwbfdnt")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Gets or sets the password, return value will always be empty.
     */
    @JvmName("cuyfcuihcwdoikfy")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'Basic'.
     */
    @JvmName("avsntryesedsufbk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets the username.
     */
    @JvmName("lsskopgmxycjmgjv")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): BasicAuthenticationArgs = BasicAuthenticationArgs(
        password = password,
        type = type ?: throw PulumiNullFieldException("type"),
        username = username,
    )
}
