@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.ClientCertAuthenticationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certificateExpirationDate Gets or sets the certificate expiration date.
 * @property certificateSubjectName Gets or sets the certificate subject name.
 * @property certificateThumbprint Gets or sets the certificate thumbprint.
 * @property password Gets or sets the certificate password, return value will always be empty.
 * @property pfx Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'ClientCertificate'.
 */
public data class ClientCertAuthenticationArgs(
    public val certificateExpirationDate: Output<String>? = null,
    public val certificateSubjectName: Output<String>? = null,
    public val certificateThumbprint: Output<String>? = null,
    public val password: Output<String>? = null,
    public val pfx: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.ClientCertAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.ClientCertAuthenticationArgs =
        com.pulumi.azurenative.scheduler.inputs.ClientCertAuthenticationArgs.builder()
            .certificateExpirationDate(certificateExpirationDate?.applyValue({ args0 -> args0 }))
            .certificateSubjectName(certificateSubjectName?.applyValue({ args0 -> args0 }))
            .certificateThumbprint(certificateThumbprint?.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .pfx(pfx?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientCertAuthenticationArgs].
 */
@PulumiTagMarker
public class ClientCertAuthenticationArgsBuilder internal constructor() {
    private var certificateExpirationDate: Output<String>? = null

    private var certificateSubjectName: Output<String>? = null

    private var certificateThumbprint: Output<String>? = null

    private var password: Output<String>? = null

    private var pfx: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Gets or sets the certificate expiration date.
     */
    @JvmName("gxavkwfbhwehddbr")
    public suspend fun certificateExpirationDate(`value`: Output<String>) {
        this.certificateExpirationDate = value
    }

    /**
     * @param value Gets or sets the certificate subject name.
     */
    @JvmName("wwrwmapapxgfxddq")
    public suspend fun certificateSubjectName(`value`: Output<String>) {
        this.certificateSubjectName = value
    }

    /**
     * @param value Gets or sets the certificate thumbprint.
     */
    @JvmName("yrhwygvaymgjyulr")
    public suspend fun certificateThumbprint(`value`: Output<String>) {
        this.certificateThumbprint = value
    }

    /**
     * @param value Gets or sets the certificate password, return value will always be empty.
     */
    @JvmName("yxhebvqmgjqroxny")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
     */
    @JvmName("jbccvylmhkmljbsx")
    public suspend fun pfx(`value`: Output<String>) {
        this.pfx = value
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'ClientCertificate'.
     */
    @JvmName("mrmhhbovcpqegxqh")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Gets or sets the certificate expiration date.
     */
    @JvmName("rnwvypjisfoxqbau")
    public suspend fun certificateExpirationDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateExpirationDate = mapped
    }

    /**
     * @param value Gets or sets the certificate subject name.
     */
    @JvmName("sptrucaaroqbgeca")
    public suspend fun certificateSubjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateSubjectName = mapped
    }

    /**
     * @param value Gets or sets the certificate thumbprint.
     */
    @JvmName("dgmjkudiawqarjng")
    public suspend fun certificateThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateThumbprint = mapped
    }

    /**
     * @param value Gets or sets the certificate password, return value will always be empty.
     */
    @JvmName("fojmujgaldhiteuv")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
     */
    @JvmName("aikpvulfrmgvslgn")
    public suspend fun pfx(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pfx = mapped
    }

    /**
     * @param value Gets or sets the HTTP authentication type.
     * Expected value is 'ClientCertificate'.
     */
    @JvmName("fylkemnrwsvvxynw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ClientCertAuthenticationArgs = ClientCertAuthenticationArgs(
        certificateExpirationDate = certificateExpirationDate,
        certificateSubjectName = certificateSubjectName,
        certificateThumbprint = certificateThumbprint,
        password = password,
        pfx = pfx,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
