@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobMaxRecurrenceArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.RecurrenceFrequency
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frequency Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
 * @property interval Gets or sets the interval between retries.
 */
public data class JobMaxRecurrenceArgs(
    public val frequency: Output<RecurrenceFrequency>? = null,
    public val interval: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobMaxRecurrenceArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobMaxRecurrenceArgs =
        com.pulumi.azurenative.scheduler.inputs.JobMaxRecurrenceArgs.builder()
            .frequency(frequency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .interval(interval?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobMaxRecurrenceArgs].
 */
@PulumiTagMarker
public class JobMaxRecurrenceArgsBuilder internal constructor() {
    private var frequency: Output<RecurrenceFrequency>? = null

    private var interval: Output<Int>? = null

    /**
     * @param value Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
     */
    @JvmName("algqtuvaqxaoocdy")
    public suspend fun frequency(`value`: Output<RecurrenceFrequency>) {
        this.frequency = value
    }

    /**
     * @param value Gets or sets the interval between retries.
     */
    @JvmName("xhuqtkodrwqwjxgw")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
     */
    @JvmName("wsfaxucgfltxukex")
    public suspend fun frequency(`value`: RecurrenceFrequency?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    /**
     * @param value Gets or sets the interval between retries.
     */
    @JvmName("wyvxrbcgyyuvxhws")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    internal fun build(): JobMaxRecurrenceArgs = JobMaxRecurrenceArgs(
        frequency = frequency,
        interval = interval,
    )
}
