@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.SkuArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.SkuDefinition
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Gets or set the SKU.
 */
public data class SkuArgs(
    public val name: Output<SkuDefinition>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.SkuArgs =
        com.pulumi.azurenative.scheduler.inputs.SkuArgs.builder()
            .name(name?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var name: Output<SkuDefinition>? = null

    /**
     * @param value Gets or set the SKU.
     */
    @JvmName("fhxtpbtksjthcnsf")
    public suspend fun name(`value`: Output<SkuDefinition>) {
        this.name = value
    }

    /**
     * @param value Gets or set the SKU.
     */
    @JvmName("ltwudcykqsynqhvb")
    public suspend fun name(`value`: SkuDefinition?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        name = name,
    )
}
