@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.StorageQueueMessageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property message Gets or sets the message.
 * @property queueName Gets or sets the queue name.
 * @property sasToken Gets or sets the SAS key.
 * @property storageAccount Gets or sets the storage account name.
 */
public data class StorageQueueMessageArgs(
    public val message: Output<String>? = null,
    public val queueName: Output<String>? = null,
    public val sasToken: Output<String>? = null,
    public val storageAccount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.StorageQueueMessageArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.StorageQueueMessageArgs =
        com.pulumi.azurenative.scheduler.inputs.StorageQueueMessageArgs.builder()
            .message(message?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .sasToken(sasToken?.applyValue({ args0 -> args0 }))
            .storageAccount(storageAccount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageQueueMessageArgs].
 */
@PulumiTagMarker
public class StorageQueueMessageArgsBuilder internal constructor() {
    private var message: Output<String>? = null

    private var queueName: Output<String>? = null

    private var sasToken: Output<String>? = null

    private var storageAccount: Output<String>? = null

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("dibqulqrjcdjxgoj")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value Gets or sets the queue name.
     */
    @JvmName("wphfiricfpexddas")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value Gets or sets the SAS key.
     */
    @JvmName("aghadlbcjytcvxah")
    public suspend fun sasToken(`value`: Output<String>) {
        this.sasToken = value
    }

    /**
     * @param value Gets or sets the storage account name.
     */
    @JvmName("cbtucfkublwxwmtc")
    public suspend fun storageAccount(`value`: Output<String>) {
        this.storageAccount = value
    }

    /**
     * @param value Gets or sets the message.
     */
    @JvmName("hacykckvcbtggcid")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    /**
     * @param value Gets or sets the queue name.
     */
    @JvmName("gspfllfneysnddsa")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value Gets or sets the SAS key.
     */
    @JvmName("epxaidmxbuadunse")
    public suspend fun sasToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param value Gets or sets the storage account name.
     */
    @JvmName("sdquwqlqmapgjkij")
    public suspend fun storageAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccount = mapped
    }

    internal fun build(): StorageQueueMessageArgs = StorageQueueMessageArgs(
        message = message,
        queueName = queueName,
        sasToken = sasToken,
        storageAccount = storageAccount,
    )
}
