@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password Gets or sets the password, return value will always be empty.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'Basic'.
 * @property username Gets or sets the username.
 */
public data class BasicAuthenticationResponse(
    public val password: String? = null,
    public val type: String,
    public val username: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.BasicAuthenticationResponse):
            BasicAuthenticationResponse = BasicAuthenticationResponse(
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
