@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateExpirationDate Gets or sets the certificate expiration date.
 * @property certificateSubjectName Gets or sets the certificate subject name.
 * @property certificateThumbprint Gets or sets the certificate thumbprint.
 * @property password Gets or sets the certificate password, return value will always be empty.
 * @property pfx Gets or sets the pfx certificate. Accepts certification in base64 encoding, return value will always be empty.
 * @property type Gets or sets the HTTP authentication type.
 * Expected value is 'ClientCertificate'.
 */
public data class ClientCertAuthenticationResponse(
    public val certificateExpirationDate: String? = null,
    public val certificateSubjectName: String? = null,
    public val certificateThumbprint: String? = null,
    public val password: String? = null,
    public val pfx: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.ClientCertAuthenticationResponse):
            ClientCertAuthenticationResponse = ClientCertAuthenticationResponse(
            certificateExpirationDate = javaType.certificateExpirationDate().map({ args0 ->
                args0
            }).orElse(null),
            certificateSubjectName = javaType.certificateSubjectName().map({ args0 -> args0 }).orElse(null),
            certificateThumbprint = javaType.certificateThumbprint().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            pfx = javaType.pfx().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
