@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property errorAction Gets or sets the error action.
 * @property queueMessage Gets or sets the storage queue message.
 * @property request Gets or sets the http requests.
 * @property retryPolicy Gets or sets the retry policy.
 * @property serviceBusQueueMessage Gets or sets the service bus queue message.
 * @property serviceBusTopicMessage Gets or sets the service bus topic message.
 * @property type Gets or sets the job action type.
 */
public data class JobActionResponse(
    public val errorAction: JobErrorActionResponse? = null,
    public val queueMessage: StorageQueueMessageResponse? = null,
    public val request: HttpRequestResponse? = null,
    public val retryPolicy: RetryPolicyResponse? = null,
    public val serviceBusQueueMessage: ServiceBusQueueMessageResponse? = null,
    public val serviceBusTopicMessage: ServiceBusTopicMessageResponse? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobActionResponse):
            JobActionResponse = JobActionResponse(
            errorAction = javaType.errorAction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobErrorActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queueMessage = javaType.queueMessage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.StorageQueueMessageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            request = javaType.request().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.HttpRequestResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.RetryPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceBusQueueMessage = javaType.serviceBusQueueMessage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.ServiceBusQueueMessageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceBusTopicMessage = javaType.serviceBusTopicMessage().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.ServiceBusTopicMessageResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
