@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authentication Gets or sets the Service Bus authentication.
 * @property brokeredMessageProperties Gets or sets the brokered message properties.
 * @property customMessageProperties Gets or sets the custom message properties.
 * @property message Gets or sets the message.
 * @property namespace Gets or sets the namespace.
 * @property queueName Gets or sets the queue name.
 * @property transportType Gets or sets the transport type.
 */
public data class ServiceBusQueueMessageResponse(
    public val authentication: ServiceBusAuthenticationResponse? = null,
    public val brokeredMessageProperties: ServiceBusBrokeredMessagePropertiesResponse? = null,
    public val customMessageProperties: Map<String, String>? = null,
    public val message: String? = null,
    public val namespace: String? = null,
    public val queueName: String? = null,
    public val transportType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.ServiceBusQueueMessageResponse):
            ServiceBusQueueMessageResponse = ServiceBusQueueMessageResponse(
            authentication = javaType.authentication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.ServiceBusAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            brokeredMessageProperties = javaType.brokeredMessageProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.ServiceBusBrokeredMessagePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customMessageProperties = javaType.customMessageProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            queueName = javaType.queueName().map({ args0 -> args0 }).orElse(null),
            transportType = javaType.transportType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
