@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scom.kotlin.inputs

import com.pulumi.azurenative.scom.inputs.MonitoringInstancePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a SCOM instance resource
 * @property azureHybridBenefit The properties to enable Azure Hybrid benefit for various SCOM infrastructure license.
 * @property databaseInstance The database instance where the SCOM Operational and Warehouse databases will be stored.
 * @property domainController Domain controller details
 * @property domainUserCredentials Domain user which will be used to join VMs to domain and login to VMs.
 * @property gmsaDetails Gmsa Details for load balancer and vmss
 * @property vNetSubnetId Virtual Network subnet id on which Aquila instance will be provisioned
 */
public data class MonitoringInstancePropertiesArgs(
    public val azureHybridBenefit: Output<AzureHybridBenefitPropertiesArgs>? = null,
    public val databaseInstance: Output<DatabaseInstancePropertiesArgs>? = null,
    public val domainController: Output<DomainControllerPropertiesArgs>? = null,
    public val domainUserCredentials: Output<DomainUserCredentialsArgs>? = null,
    public val gmsaDetails: Output<GmsaDetailsArgs>? = null,
    public val vNetSubnetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scom.inputs.MonitoringInstancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.scom.inputs.MonitoringInstancePropertiesArgs =
        com.pulumi.azurenative.scom.inputs.MonitoringInstancePropertiesArgs.builder()
            .azureHybridBenefit(
                azureHybridBenefit?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .databaseInstance(databaseInstance?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainController(domainController?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainUserCredentials(
                domainUserCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .gmsaDetails(gmsaDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vNetSubnetId(vNetSubnetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitoringInstancePropertiesArgs].
 */
@PulumiTagMarker
public class MonitoringInstancePropertiesArgsBuilder internal constructor() {
    private var azureHybridBenefit: Output<AzureHybridBenefitPropertiesArgs>? = null

    private var databaseInstance: Output<DatabaseInstancePropertiesArgs>? = null

    private var domainController: Output<DomainControllerPropertiesArgs>? = null

    private var domainUserCredentials: Output<DomainUserCredentialsArgs>? = null

    private var gmsaDetails: Output<GmsaDetailsArgs>? = null

    private var vNetSubnetId: Output<String>? = null

    /**
     * @param value The properties to enable Azure Hybrid benefit for various SCOM infrastructure license.
     */
    @JvmName("kievirigrsrqyhhc")
    public suspend fun azureHybridBenefit(`value`: Output<AzureHybridBenefitPropertiesArgs>) {
        this.azureHybridBenefit = value
    }

    /**
     * @param value The database instance where the SCOM Operational and Warehouse databases will be stored.
     */
    @JvmName("vicdevficatsthup")
    public suspend fun databaseInstance(`value`: Output<DatabaseInstancePropertiesArgs>) {
        this.databaseInstance = value
    }

    /**
     * @param value Domain controller details
     */
    @JvmName("aqksfctkpyleaksk")
    public suspend fun domainController(`value`: Output<DomainControllerPropertiesArgs>) {
        this.domainController = value
    }

    /**
     * @param value Domain user which will be used to join VMs to domain and login to VMs.
     */
    @JvmName("ojceeinpxfcjnaot")
    public suspend fun domainUserCredentials(`value`: Output<DomainUserCredentialsArgs>) {
        this.domainUserCredentials = value
    }

    /**
     * @param value Gmsa Details for load balancer and vmss
     */
    @JvmName("pbxvrbscwbqonpgi")
    public suspend fun gmsaDetails(`value`: Output<GmsaDetailsArgs>) {
        this.gmsaDetails = value
    }

    /**
     * @param value Virtual Network subnet id on which Aquila instance will be provisioned
     */
    @JvmName("obxysbgcrukwrukg")
    public suspend fun vNetSubnetId(`value`: Output<String>) {
        this.vNetSubnetId = value
    }

    /**
     * @param value The properties to enable Azure Hybrid benefit for various SCOM infrastructure license.
     */
    @JvmName("qkfpbcyaenlswtwg")
    public suspend fun azureHybridBenefit(`value`: AzureHybridBenefitPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureHybridBenefit = mapped
    }

    /**
     * @param argument The properties to enable Azure Hybrid benefit for various SCOM infrastructure license.
     */
    @JvmName("qkgwrcaeerxkrciw")
    public suspend
    fun azureHybridBenefit(argument: suspend AzureHybridBenefitPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureHybridBenefitPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureHybridBenefit = mapped
    }

    /**
     * @param value The database instance where the SCOM Operational and Warehouse databases will be stored.
     */
    @JvmName("rfkhuiusebwwrhyj")
    public suspend fun databaseInstance(`value`: DatabaseInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseInstance = mapped
    }

    /**
     * @param argument The database instance where the SCOM Operational and Warehouse databases will be stored.
     */
    @JvmName("puskynlximiiufqt")
    public suspend
    fun databaseInstance(argument: suspend DatabaseInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.databaseInstance = mapped
    }

    /**
     * @param value Domain controller details
     */
    @JvmName("bhxecpkyugygdrbb")
    public suspend fun domainController(`value`: DomainControllerPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainController = mapped
    }

    /**
     * @param argument Domain controller details
     */
    @JvmName("dijqnyaanxcrmkvi")
    public suspend
    fun domainController(argument: suspend DomainControllerPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DomainControllerPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainController = mapped
    }

    /**
     * @param value Domain user which will be used to join VMs to domain and login to VMs.
     */
    @JvmName("odftxnxgprddjjby")
    public suspend fun domainUserCredentials(`value`: DomainUserCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainUserCredentials = mapped
    }

    /**
     * @param argument Domain user which will be used to join VMs to domain and login to VMs.
     */
    @JvmName("mnynmhicjmbqrkaa")
    public suspend
    fun domainUserCredentials(argument: suspend DomainUserCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainUserCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainUserCredentials = mapped
    }

    /**
     * @param value Gmsa Details for load balancer and vmss
     */
    @JvmName("vkytshuygrvrglvv")
    public suspend fun gmsaDetails(`value`: GmsaDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gmsaDetails = mapped
    }

    /**
     * @param argument Gmsa Details for load balancer and vmss
     */
    @JvmName("lrlcxkwbdqkhvqmw")
    public suspend fun gmsaDetails(argument: suspend GmsaDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = GmsaDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.gmsaDetails = mapped
    }

    /**
     * @param value Virtual Network subnet id on which Aquila instance will be provisioned
     */
    @JvmName("msoqpqbyceihubhc")
    public suspend fun vNetSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vNetSubnetId = mapped
    }

    internal fun build(): MonitoringInstancePropertiesArgs = MonitoringInstancePropertiesArgs(
        azureHybridBenefit = azureHybridBenefit,
        databaseInstance = databaseInstance,
        domainController = domainController,
        domainUserCredentials = domainUserCredentials,
        gmsaDetails = gmsaDetails,
        vNetSubnetId = vNetSubnetId,
    )
}
