@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.GuestAgentArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.enums.ProvisioningAction
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestCredentialArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.GuestCredentialArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.HttpProxyConfigurationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.HttpProxyConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the GuestAgent.
 * Azure REST API version: 2022-05-21-preview.
 * Other available API versions: 2023-04-01-preview.
 * ## Example Usage
 * ### CreateGuestAgent
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestAgent = new AzureNative.ScVmm.GuestAgent("guestAgent", new()
 *     {
 *         Credentials = new AzureNative.ScVmm.Inputs.GuestCredentialArgs
 *         {
 *             Password = "<password>",
 *             Username = "tempuser",
 *         },
 *         GuestAgentName = "default",
 *         HttpProxyConfig = new AzureNative.ScVmm.Inputs.HttpProxyConfigurationArgs
 *         {
 *             HttpsProxy = "http://192.1.2.3:8080",
 *         },
 *         ProvisioningAction = "install",
 *         ResourceGroupName = "testrg",
 *         VirtualMachineName = "ContosoVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewGuestAgent(ctx, "guestAgent", &scvmm.GuestAgentArgs{
 * 			Credentials: &scvmm.GuestCredentialArgs{
 * 				Password: pulumi.String("<password>"),
 * 				Username: pulumi.String("tempuser"),
 * 			},
 * 			GuestAgentName: pulumi.String("default"),
 * 			HttpProxyConfig: &scvmm.HttpProxyConfigurationArgs{
 * 				HttpsProxy: pulumi.String("http://192.1.2.3:8080"),
 * 			},
 * 			ProvisioningAction: pulumi.String("install"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			VirtualMachineName: pulumi.String("ContosoVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.GuestAgent;
 * import com.pulumi.azurenative.scvmm.GuestAgentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestAgent = new GuestAgent("guestAgent", GuestAgentArgs.builder()
 *             .credentials(Map.ofEntries(
 *                 Map.entry("password", "<password>"),
 *                 Map.entry("username", "tempuser")
 *             ))
 *             .guestAgentName("default")
 *             .httpProxyConfig(Map.of("httpsProxy", "http://192.1.2.3:8080"))
 *             .provisioningAction("install")
 *             .resourceGroupName("testrg")
 *             .virtualMachineName("ContosoVm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:GuestAgent default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachines/{virtualMachineName}/guestAgents/{guestAgentName}
 * ```
 * @property credentials Username / Password Credentials to provision guest agent.
 * @property guestAgentName Name of the guestAgents.
 * @property httpProxyConfig HTTP Proxy configuration for the VM.
 * @property provisioningAction Gets or sets the guest agent provisioning action.
 * @property resourceGroupName The name of the resource group.
 * @property virtualMachineName Name of the vm.
 */
public data class GuestAgentArgs(
    public val credentials: Output<GuestCredentialArgs>? = null,
    public val guestAgentName: Output<String>? = null,
    public val httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null,
    public val provisioningAction: Output<Either<String, ProvisioningAction>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val virtualMachineName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.GuestAgentArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.GuestAgentArgs =
        com.pulumi.azurenative.scvmm.GuestAgentArgs.builder()
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .guestAgentName(guestAgentName?.applyValue({ args0 -> args0 }))
            .httpProxyConfig(httpProxyConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningAction(
                provisioningAction?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .virtualMachineName(virtualMachineName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestAgentArgs].
 */
@PulumiTagMarker
public class GuestAgentArgsBuilder internal constructor() {
    private var credentials: Output<GuestCredentialArgs>? = null

    private var guestAgentName: Output<String>? = null

    private var httpProxyConfig: Output<HttpProxyConfigurationArgs>? = null

    private var provisioningAction: Output<Either<String, ProvisioningAction>>? = null

    private var resourceGroupName: Output<String>? = null

    private var virtualMachineName: Output<String>? = null

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("blnhwynfqcplkjbb")
    public suspend fun credentials(`value`: Output<GuestCredentialArgs>) {
        this.credentials = value
    }

    /**
     * @param value Name of the guestAgents.
     */
    @JvmName("phrpsmsgelyrkkla")
    public suspend fun guestAgentName(`value`: Output<String>) {
        this.guestAgentName = value
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("yrbqesrhevqwxgog")
    public suspend fun httpProxyConfig(`value`: Output<HttpProxyConfigurationArgs>) {
        this.httpProxyConfig = value
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("lfajshovqikmjxpn")
    public suspend fun provisioningAction(`value`: Output<Either<String, ProvisioningAction>>) {
        this.provisioningAction = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nafibepkkcymfssx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("enbhxlsoassqcosy")
    public suspend fun virtualMachineName(`value`: Output<String>) {
        this.virtualMachineName = value
    }

    /**
     * @param value Username / Password Credentials to provision guest agent.
     */
    @JvmName("vpiugbylnlecfqtk")
    public suspend fun credentials(`value`: GuestCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Username / Password Credentials to provision guest agent.
     */
    @JvmName("arurdltjwvrnvofr")
    public suspend fun credentials(argument: suspend GuestCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = GuestCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value Name of the guestAgents.
     */
    @JvmName("yjtlhtpovwifidyp")
    public suspend fun guestAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestAgentName = mapped
    }

    /**
     * @param value HTTP Proxy configuration for the VM.
     */
    @JvmName("hdhspxvnsrusknus")
    public suspend fun httpProxyConfig(`value`: HttpProxyConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpProxyConfig = mapped
    }

    /**
     * @param argument HTTP Proxy configuration for the VM.
     */
    @JvmName("ulndyixuhaxclgqt")
    public suspend
    fun httpProxyConfig(argument: suspend HttpProxyConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = HttpProxyConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.httpProxyConfig = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("mciwfbogrsisaywg")
    public suspend fun provisioningAction(`value`: Either<String, ProvisioningAction>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("kjjluxrimwoenkcw")
    public fun provisioningAction(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value Gets or sets the guest agent provisioning action.
     */
    @JvmName("exqexdqshunwuirf")
    public fun provisioningAction(`value`: ProvisioningAction) {
        val toBeMapped = Either.ofRight<String, ProvisioningAction>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningAction = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("agrxtarjrikwlcty")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the vm.
     */
    @JvmName("bccxghokthrnokxd")
    public suspend fun virtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineName = mapped
    }

    internal fun build(): GuestAgentArgs = GuestAgentArgs(
        credentials = credentials,
        guestAgentName = guestAgentName,
        httpProxyConfig = httpProxyConfig,
        provisioningAction = provisioningAction,
        resourceGroupName = resourceGroupName,
        virtualMachineName = virtualMachineName,
    )
}
