@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.scvmm.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InventoryItem].
 */
@PulumiTagMarker
public class InventoryItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InventoryItemArgs = InventoryItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InventoryItemArgsBuilder.() -> Unit) {
        val builder = InventoryItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InventoryItem {
        val builtJavaResource = com.pulumi.azurenative.scvmm.InventoryItem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InventoryItem(builtJavaResource)
    }
}

/**
 * Defines the inventory item.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateInventoryItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var inventoryItem = new AzureNative.ScVmm.InventoryItem("inventoryItem", new()
 *     {
 *         InventoryItemName = "12345678-1234-1234-1234-123456789abc",
 *         InventoryType = "Cloud",
 *         ResourceGroupName = "testrg",
 *         VmmServerName = "ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewInventoryItem(ctx, "inventoryItem", &scvmm.InventoryItemArgs{
 * 			InventoryItemName: pulumi.String("12345678-1234-1234-1234-123456789abc"),
 * 			InventoryType:     pulumi.String("Cloud"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			VmmServerName:     pulumi.String("ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.InventoryItem;
 * import com.pulumi.azurenative.scvmm.InventoryItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var inventoryItem = new InventoryItem("inventoryItem", InventoryItemArgs.builder()
 *             .inventoryItemName("12345678-1234-1234-1234-123456789abc")
 *             .inventoryType("Cloud")
 *             .resourceGroupName("testrg")
 *             .vmmServerName("ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:InventoryItem 12345678-1234-1234-1234-123456789abc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/vmmServers/{vmmServerName}/inventoryItems/{inventoryItemName}
 * ```
 */
public class InventoryItem internal constructor(
    override val javaResource: com.pulumi.azurenative.scvmm.InventoryItem,
) : KotlinCustomResource(javaResource, InventoryItemMapper) {
    /**
     * Gets the Managed Object name in VMM for the inventory item.
     */
    public val inventoryItemName: Output<String>
        get() = javaResource.inventoryItemName().applyValue({ args0 -> args0 })

    /**
     * They inventory type.
     */
    public val inventoryType: Output<String>
        get() = javaResource.inventoryType().applyValue({ args0 -> args0 })

    /**
     * Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets the tracked resource id corresponding to the inventory resource.
     */
    public val managedResourceId: Output<String>
        get() = javaResource.managedResourceId().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the UUID (which is assigned by VMM) for the inventory item.
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object InventoryItemMapper : ResourceMapper<InventoryItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scvmm.InventoryItem::class == javaResource::class

    override fun map(javaResource: Resource): InventoryItem = InventoryItem(
        javaResource as
            com.pulumi.azurenative.scvmm.InventoryItem,
    )
}

/**
 * @see [InventoryItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InventoryItem].
 */
public suspend fun inventoryItem(
    name: String,
    block: suspend InventoryItemResourceBuilder.() -> Unit,
): InventoryItem {
    val builder = InventoryItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InventoryItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inventoryItem(name: String): InventoryItem {
    val builder = InventoryItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
