@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.HardwareProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.HardwareProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.InfrastructureProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.InfrastructureProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.NetworkProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.NetworkProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.OsProfileForVMInstanceArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.OsProfileForVMInstanceArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.StorageProfileArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.StorageProfileArgsBuilder
import com.pulumi.azurenative.scvmm.kotlin.inputs.VirtualMachineInstancePropertiesAvailabilitySetsArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define the virtualMachineInstance.
 * Azure REST API version: 2023-04-01-preview.
 * Other available API versions: 2023-10-07.
 * ## Example Usage
 * ### CreateVirtualMachine
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineInstance = new AzureNative.ScVmm.VirtualMachineInstance("virtualMachineInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         HardwareProfile = new AzureNative.ScVmm.Inputs.HardwareProfileArgs
 *         {
 *             CpuCount = 4,
 *             MemoryMB = 4196,
 *         },
 *         InfrastructureProfile = new AzureNative.ScVmm.Inputs.InfrastructureProfileArgs
 *         {
 *             CloudId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud",
 *             TemplateId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate",
 *             VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *         },
 *         ResourceUri = "subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachineInstance(ctx, "virtualMachineInstance", &scvmm.VirtualMachineInstanceArgs{
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			HardwareProfile: &scvmm.HardwareProfileArgs{
 * 				CpuCount: pulumi.Int(4),
 * 				MemoryMB: pulumi.Int(4196),
 * 			},
 * 			InfrastructureProfile: &scvmm.InfrastructureProfileArgs{
 * 				CloudId:     pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
 * 				TemplateId:  pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
 * 				VmmServerId: pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 			},
 * 			ResourceUri: pulumi.String("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachineInstance;
 * import com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineInstance = new VirtualMachineInstance("virtualMachineInstance", VirtualMachineInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.ExtendedLocation/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .hardwareProfile(Map.ofEntries(
 *                 Map.entry("cpuCount", 4),
 *                 Map.entry("memoryMB", 4196)
 *             ))
 *             .infrastructureProfile(Map.ofEntries(
 *                 Map.entry("cloudId", "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/Clouds/HRCloud"),
 *                 Map.entry("templateId", "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VirtualMachineTemplates/HRVirtualMachineTemplate"),
 *                 Map.entry("vmmServerId", "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             ))
 *             .resourceUri("subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.HybridCompute/machines/DemoVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachineInstance default /{resourceUri}/providers/Microsoft.ScVmm/virtualMachineInstances/default
 * ```
 * @property availabilitySets Availability Sets in vm.
 * @property extendedLocation Gets or sets the extended location.
 * @property hardwareProfile Hardware properties.
 * @property infrastructureProfile Gets the infrastructure profile.
 * @property networkProfile Network properties.
 * @property osProfile OS properties.
 * @property resourceUri The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
 * @property storageProfile Storage properties.
 */
public data class VirtualMachineInstanceArgs(
    public val availabilitySets: Output<List<VirtualMachineInstancePropertiesAvailabilitySetsArgs>>? =
        null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hardwareProfile: Output<HardwareProfileArgs>? = null,
    public val infrastructureProfile: Output<InfrastructureProfileArgs>? = null,
    public val networkProfile: Output<NetworkProfileArgs>? = null,
    public val osProfile: Output<OsProfileForVMInstanceArgs>? = null,
    public val resourceUri: Output<String>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs =
        com.pulumi.azurenative.scvmm.VirtualMachineInstanceArgs.builder()
            .availabilitySets(
                availabilitySets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hardwareProfile(hardwareProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .infrastructureProfile(
                infrastructureProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkProfile(networkProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .osProfile(osProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceUri(resourceUri?.applyValue({ args0 -> args0 }))
            .storageProfile(
                storageProfile?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstanceArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstanceArgsBuilder internal constructor() {
    private var availabilitySets: Output<List<VirtualMachineInstancePropertiesAvailabilitySetsArgs>>? =
        null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hardwareProfile: Output<HardwareProfileArgs>? = null

    private var infrastructureProfile: Output<InfrastructureProfileArgs>? = null

    private var networkProfile: Output<NetworkProfileArgs>? = null

    private var osProfile: Output<OsProfileForVMInstanceArgs>? = null

    private var resourceUri: Output<String>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    /**
     * @param value Availability Sets in vm.
     */
    @JvmName("ocreauxreitivran")
    public suspend
    fun availabilitySets(`value`: Output<List<VirtualMachineInstancePropertiesAvailabilitySetsArgs>>) {
        this.availabilitySets = value
    }

    @JvmName("pkvaoqfdxfvdhcly")
    public suspend fun availabilitySets(
        vararg
        values: Output<VirtualMachineInstancePropertiesAvailabilitySetsArgs>,
    ) {
        this.availabilitySets = Output.all(values.asList())
    }

    /**
     * @param values Availability Sets in vm.
     */
    @JvmName("qqleproftgdmmaij")
    public suspend
    fun availabilitySets(values: List<Output<VirtualMachineInstancePropertiesAvailabilitySetsArgs>>) {
        this.availabilitySets = Output.all(values)
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("atcuctcsewkowxsc")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("sofjydhxdfsuccad")
    public suspend fun hardwareProfile(`value`: Output<HardwareProfileArgs>) {
        this.hardwareProfile = value
    }

    /**
     * @param value Gets the infrastructure profile.
     */
    @JvmName("mpbkaqqroprsjjbp")
    public suspend fun infrastructureProfile(`value`: Output<InfrastructureProfileArgs>) {
        this.infrastructureProfile = value
    }

    /**
     * @param value Network properties.
     */
    @JvmName("wbaoftrqxxvakeop")
    public suspend fun networkProfile(`value`: Output<NetworkProfileArgs>) {
        this.networkProfile = value
    }

    /**
     * @param value OS properties.
     */
    @JvmName("ncpcvilvipguwsmc")
    public suspend fun osProfile(`value`: Output<OsProfileForVMInstanceArgs>) {
        this.osProfile = value
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("ydbwqnjtbdcgdorn")
    public suspend fun resourceUri(`value`: Output<String>) {
        this.resourceUri = value
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("ctogtowthgogwxqh")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Availability Sets in vm.
     */
    @JvmName("olyacxdyngmsihka")
    public suspend
    fun availabilitySets(`value`: List<VirtualMachineInstancePropertiesAvailabilitySetsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("vjdcyidxuytpweuw")
    public suspend
    fun availabilitySets(argument: List<suspend VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("hscuajshvmtwooin")
    public suspend fun availabilitySets(
        vararg
        argument: suspend VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param argument Availability Sets in vm.
     */
    @JvmName("wavcstrsmobjsoat")
    public suspend
    fun availabilitySets(argument: suspend VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                VirtualMachineInstancePropertiesAvailabilitySetsArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.availabilitySets = mapped
    }

    /**
     * @param values Availability Sets in vm.
     */
    @JvmName("xeugmvawgkvitdpr")
    public suspend fun availabilitySets(
        vararg
        values: VirtualMachineInstancePropertiesAvailabilitySetsArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilitySets = mapped
    }

    /**
     * @param value Gets or sets the extended location.
     */
    @JvmName("chaylkbsslenoxxw")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Gets or sets the extended location.
     */
    @JvmName("rfjtburnoojmiqpf")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Hardware properties.
     */
    @JvmName("kpeifgfftoctwfmm")
    public suspend fun hardwareProfile(`value`: HardwareProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hardwareProfile = mapped
    }

    /**
     * @param argument Hardware properties.
     */
    @JvmName("fqsddhduqipelyti")
    public suspend fun hardwareProfile(argument: suspend HardwareProfileArgsBuilder.() -> Unit) {
        val toBeMapped = HardwareProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hardwareProfile = mapped
    }

    /**
     * @param value Gets the infrastructure profile.
     */
    @JvmName("lipwrcbvmivvijkl")
    public suspend fun infrastructureProfile(`value`: InfrastructureProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureProfile = mapped
    }

    /**
     * @param argument Gets the infrastructure profile.
     */
    @JvmName("enkrmxucwhxsyjlq")
    public suspend
    fun infrastructureProfile(argument: suspend InfrastructureProfileArgsBuilder.() -> Unit) {
        val toBeMapped = InfrastructureProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.infrastructureProfile = mapped
    }

    /**
     * @param value Network properties.
     */
    @JvmName("rywjydkhcagcbmsd")
    public suspend fun networkProfile(`value`: NetworkProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkProfile = mapped
    }

    /**
     * @param argument Network properties.
     */
    @JvmName("qdfdsfpixpaotmth")
    public suspend fun networkProfile(argument: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkProfile = mapped
    }

    /**
     * @param value OS properties.
     */
    @JvmName("uvhhtxdcdjsbuthh")
    public suspend fun osProfile(`value`: OsProfileForVMInstanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osProfile = mapped
    }

    /**
     * @param argument OS properties.
     */
    @JvmName("onnqlrmoiqxhphdw")
    public suspend fun osProfile(argument: suspend OsProfileForVMInstanceArgsBuilder.() -> Unit) {
        val toBeMapped = OsProfileForVMInstanceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osProfile = mapped
    }

    /**
     * @param value The fully qualified Azure Resource manager identifier of the Hybrid Compute machine resource to be extended.
     */
    @JvmName("eiotrdelarxmdieo")
    public suspend fun resourceUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceUri = mapped
    }

    /**
     * @param value Storage properties.
     */
    @JvmName("eudviedjeamhghwe")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage properties.
     */
    @JvmName("tnhduslhynfjejar")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    internal fun build(): VirtualMachineInstanceArgs = VirtualMachineInstanceArgs(
        availabilitySets = availabilitySets,
        extendedLocation = extendedLocation,
        hardwareProfile = hardwareProfile,
        infrastructureProfile = infrastructureProfile,
        networkProfile = networkProfile,
        osProfile = osProfile,
        resourceUri = resourceUri,
        storageProfile = storageProfile,
    )
}
