@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin

import com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs.builder
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.scvmm.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The VirtualMachineTemplates resource definition.
 * Azure REST API version: 2022-05-21-preview. Prior API version in Azure Native 1.x: 2020-06-05-preview.
 * Other available API versions: 2023-04-01-preview, 2023-10-07.
 * ## Example Usage
 * ### CreateVirtualMachineTemplate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineTemplate = new AzureNative.ScVmm.VirtualMachineTemplate("virtualMachineTemplate", new()
 *     {
 *         ExtendedLocation = new AzureNative.ScVmm.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso",
 *             Type = "customLocation",
 *         },
 *         Location = "East US",
 *         ResourceGroupName = "testrg",
 *         Uuid = "aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee",
 *         VirtualMachineTemplateName = "HRVirtualMachineTemplate",
 *         VmmServerId = "/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/scvmm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := scvmm.NewVirtualMachineTemplate(ctx, "virtualMachineTemplate", &scvmm.VirtualMachineTemplateArgs{
 * 			ExtendedLocation: &scvmm.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 * 				Type: pulumi.String("customLocation"),
 * 			},
 * 			Location:                   pulumi.String("East US"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			Uuid:                       pulumi.String("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee"),
 * 			VirtualMachineTemplateName: pulumi.String("HRVirtualMachineTemplate"),
 * 			VmmServerId:                pulumi.String("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.scvmm.VirtualMachineTemplate;
 * import com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineTemplate = new VirtualMachineTemplate("virtualMachineTemplate", VirtualMachineTemplateArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a5015e1c-867f-4533-8541-85cd470d0cfb/resourceGroups/demoRG/providers/Microsoft.Arc/customLocations/contoso"),
 *                 Map.entry("type", "customLocation")
 *             ))
 *             .location("East US")
 *             .resourceGroupName("testrg")
 *             .uuid("aaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee")
 *             .virtualMachineTemplateName("HRVirtualMachineTemplate")
 *             .vmmServerId("/subscriptions/fd3c3665-1729-4b7b-9a38-238e83b0f98b/resourceGroups/testrg/providers/Microsoft.SCVMM/VMMServers/ContosoVMMServer")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scvmm:VirtualMachineTemplate HRVirtualMachineTemplate /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ScVmm/virtualMachineTemplates/{virtualMachineTemplateName}
 * ```
 * @property extendedLocation The extended location.
 * @property inventoryItemId Gets or sets the inventory Item ID for the resource.
 * @property location Gets or sets the location.
 * @property resourceGroupName The name of the resource group.
 * @property tags Resource tags
 * @property uuid Unique ID of the virtual machine template.
 * @property virtualMachineTemplateName Name of the VirtualMachineTemplate.
 * @property vmmServerId ARM Id of the vmmServer resource in which this resource resides.
 */
public data class VirtualMachineTemplateArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val inventoryItemId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val uuid: Output<String>? = null,
    public val virtualMachineTemplateName: Output<String>? = null,
    public val vmmServerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs =
        com.pulumi.azurenative.scvmm.VirtualMachineTemplateArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inventoryItemId(inventoryItemId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .uuid(uuid?.applyValue({ args0 -> args0 }))
            .virtualMachineTemplateName(virtualMachineTemplateName?.applyValue({ args0 -> args0 }))
            .vmmServerId(vmmServerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineTemplateArgs].
 */
@PulumiTagMarker
public class VirtualMachineTemplateArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var inventoryItemId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var uuid: Output<String>? = null

    private var virtualMachineTemplateName: Output<String>? = null

    private var vmmServerId: Output<String>? = null

    /**
     * @param value The extended location.
     */
    @JvmName("yqfrayddfchogxth")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("webssawvswxddwmu")
    public suspend fun inventoryItemId(`value`: Output<String>) {
        this.inventoryItemId = value
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("jrfbubfisfrqller")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("xhtfstmpljolkhhk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("pnaxpmbaylkdvqxy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unique ID of the virtual machine template.
     */
    @JvmName("vlpmadmfjhqkikpb")
    public suspend fun uuid(`value`: Output<String>) {
        this.uuid = value
    }

    /**
     * @param value Name of the VirtualMachineTemplate.
     */
    @JvmName("eksxtxmatkaeusxr")
    public suspend fun virtualMachineTemplateName(`value`: Output<String>) {
        this.virtualMachineTemplateName = value
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("sfgejirwgvtpigbd")
    public suspend fun vmmServerId(`value`: Output<String>) {
        this.vmmServerId = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("obfsuoirqxxkwxva")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("sddmyoqqaglujirl")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value Gets or sets the inventory Item ID for the resource.
     */
    @JvmName("tkckrkjjacbbrcqs")
    public suspend fun inventoryItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inventoryItemId = mapped
    }

    /**
     * @param value Gets or sets the location.
     */
    @JvmName("rmryrrursbgaeqfl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("drsrtsqotkfxbgwq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("tjiffujogapuchpu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("punjlukiysvftang")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Unique ID of the virtual machine template.
     */
    @JvmName("ycgacciomoikeiem")
    public suspend fun uuid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uuid = mapped
    }

    /**
     * @param value Name of the VirtualMachineTemplate.
     */
    @JvmName("cpjgwrukqgkqnayj")
    public suspend fun virtualMachineTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineTemplateName = mapped
    }

    /**
     * @param value ARM Id of the vmmServer resource in which this resource resides.
     */
    @JvmName("djxabajdbcyyaerw")
    public suspend fun vmmServerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmmServerId = mapped
    }

    internal fun build(): VirtualMachineTemplateArgs = VirtualMachineTemplateArgs(
        extendedLocation = extendedLocation,
        inventoryItemId = inventoryItemId,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        uuid = uuid,
        virtualMachineTemplateName = virtualMachineTemplateName,
        vmmServerId = vmmServerId,
    )
}
