@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetCloudPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cloudName Name of the Cloud.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetCloudPlainArgs(
    public val cloudName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetCloudPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetCloudPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetCloudPlainArgs.builder()
            .cloudName(cloudName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCloudPlainArgs].
 */
@PulumiTagMarker
public class GetCloudPlainArgsBuilder internal constructor() {
    private var cloudName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Cloud.
     */
    @JvmName("qhurkcsstbkjbjpm")
    public suspend fun cloudName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wxtsfpqnkmbmqwub")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCloudPlainArgs = GetCloudPlainArgs(
        cloudName = cloudName ?: throw PulumiNullFieldException("cloudName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
