@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetVirtualNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkName Name of the VirtualNetwork.
 */
public data class GetVirtualNetworkPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetVirtualNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetVirtualNetworkPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetVirtualNetworkPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkName(virtualNetworkName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sgvqbqauujeshdws")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the VirtualNetwork.
     */
    @JvmName("pgurkriobxdsnkcb")
    public suspend fun virtualNetworkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkName = mapped
    }

    internal fun build(): GetVirtualNetworkPlainArgs = GetVirtualNetworkPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkName = virtualNetworkName ?: throw PulumiNullFieldException("virtualNetworkName"),
    )
}
