@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GetVmmServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property vmmServerName Name of the VMMServer.
 */
public data class GetVmmServerPlainArgs(
    public val resourceGroupName: String,
    public val vmmServerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GetVmmServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GetVmmServerPlainArgs =
        com.pulumi.azurenative.scvmm.inputs.GetVmmServerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmmServerName(vmmServerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVmmServerPlainArgs].
 */
@PulumiTagMarker
public class GetVmmServerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var vmmServerName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("joqxppunyncvhtre")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the VMMServer.
     */
    @JvmName("tvgyjhdwwsigocpd")
    public suspend fun vmmServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmmServerName = mapped
    }

    internal fun build(): GetVmmServerPlainArgs = GetVmmServerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vmmServerName = vmmServerName ?: throw PulumiNullFieldException("vmmServerName"),
    )
}
