@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scvmm.kotlin.inputs

import com.pulumi.azurenative.scvmm.inputs.GuestAgentProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the resource properties.
 * @property clientPublicKey Gets or sets the Public Key provided by the client for enabling guest management.
 */
public data class GuestAgentProfileArgs(
    public val clientPublicKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scvmm.inputs.GuestAgentProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.scvmm.inputs.GuestAgentProfileArgs =
        com.pulumi.azurenative.scvmm.inputs.GuestAgentProfileArgs.builder()
            .clientPublicKey(clientPublicKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestAgentProfileArgs].
 */
@PulumiTagMarker
public class GuestAgentProfileArgsBuilder internal constructor() {
    private var clientPublicKey: Output<String>? = null

    /**
     * @param value Gets or sets the Public Key provided by the client for enabling guest management.
     */
    @JvmName("tvjvcoathsycujpo")
    public suspend fun clientPublicKey(`value`: Output<String>) {
        this.clientPublicKey = value
    }

    /**
     * @param value Gets or sets the Public Key provided by the client for enabling guest management.
     */
    @JvmName("onafcfwfhavmaslx")
    public suspend fun clientPublicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPublicKey = mapped
    }

    internal fun build(): GuestAgentProfileArgs = GuestAgentProfileArgs(
        clientPublicKey = clientPublicKey,
    )
}
