@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property searchServiceName The name of the Azure Cognitive Search service associated with the specified resource group.
 */
public data class GetServicePlainArgs(
    public val resourceGroupName: String,
    public val searchServiceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.search.inputs.GetServicePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .searchServiceName(searchServiceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var searchServiceName: String? = null

    /**
     * @param value The name of the resource group within the current subscription. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("mftnmwmhbbjhwyyg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Azure Cognitive Search service associated with the specified resource group.
     */
    @JvmName("xnxwgdywargbyqbl")
    public suspend fun searchServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.searchServiceName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        searchServiceName = searchServiceName ?: throw PulumiNullFieldException("searchServiceName"),
    )
}
