@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.inputs

import com.pulumi.azurenative.search.inputs.IpRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The IP restriction rule of the Azure Cognitive Search service.
 * @property value Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in CIDR format (eg., 123.1.2.3/24) to be allowed.
 */
public data class IpRuleArgs(
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.search.inputs.IpRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.search.inputs.IpRuleArgs =
        com.pulumi.azurenative.search.inputs.IpRuleArgs.builder()
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpRuleArgs].
 */
@PulumiTagMarker
public class IpRuleArgsBuilder internal constructor() {
    private var `value`: Output<String>? = null

    /**
     * @param value Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in CIDR format (eg., 123.1.2.3/24) to be allowed.
     */
    @JvmName("cuonynrusoisrkrn")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Value corresponding to a single IPv4 address (eg., 123.1.2.3) or an IP range in CIDR format (eg., 123.1.2.3/24) to be allowed.
     */
    @JvmName("pncayijewmfucbho")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IpRuleArgs = IpRuleArgs(
        `value` = `value`,
    )
}
