@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Describes the current state of an existing Private Link Service connection to the Azure Private Endpoint.
 * @property actionsRequired A description of any extra actions that may be required.
 * @property description The description for the private link service connection state.
 * @property status Status of the the private link service connection. Can be Pending, Approved, Rejected, or Disconnected.
 */
public data class PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState(
    public val actionsRequired: String? = null,
    public val description: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState):
            PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState =
            PrivateEndpointConnectionPropertiesResponsePrivateLinkServiceConnectionState(
                actionsRequired = javaType.actionsRequired().map({ args0 -> args0 }).orElse(null),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
