@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.search.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the SKU of an Azure Cognitive Search Service, which determines price tier and capacity limits.
 * @property name The SKU of the search service. Valid values include: 'free': Shared service. 'basic': Dedicated service with up to 3 replicas. 'standard': Dedicated service with up to 12 partitions and 12 replicas. 'standard2': Similar to standard, but with more capacity per search unit. 'standard3': The largest Standard offering with up to 12 partitions and 12 replicas (or up to 3 partitions with more indexes if you also set the hostingMode property to 'highDensity'). 'storage_optimized_l1': Supports 1TB per partition, up to 12 partitions. 'storage_optimized_l2': Supports 2TB per partition, up to 12 partitions.'
 */
public data class SkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.search.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
