@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.APICollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An API collection as represented by Defender for APIs.
 * Azure REST API version: 2022-11-20-preview.
 * ## Example Usage
 * ### Onboard an Azure API Management API to Defender for APIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var apiCollection = new AzureNative.Security.APICollection("apiCollection", new()
 *     {
 *         ApiCollectionId = "echo-api",
 *         ResourceGroupName = "rg1",
 *         ServiceName = "apimService1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAPICollection(ctx, "apiCollection", &security.APICollectionArgs{
 * 			ApiCollectionId:   pulumi.String("echo-api"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ServiceName:       pulumi.String("apimService1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.APICollection;
 * import com.pulumi.azurenative.security.APICollectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var apiCollection = new APICollection("apiCollection", APICollectionArgs.builder()
 *             .apiCollectionId("echo-api")
 *             .resourceGroupName("rg1")
 *             .serviceName("apimService1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:APICollection echo-api /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ApiManagement/service/{serviceName}/providers/Microsoft.Security/apiCollections/{apiCollectionId}
 * ```
 * @property apiCollectionId A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the API Management service.
 */
public data class APICollectionArgs(
    public val apiCollectionId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.APICollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.APICollectionArgs =
        com.pulumi.azurenative.security.APICollectionArgs.builder()
            .apiCollectionId(apiCollectionId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [APICollectionArgs].
 */
@PulumiTagMarker
public class APICollectionArgsBuilder internal constructor() {
    private var apiCollectionId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
     */
    @JvmName("aphpssrhhyurxyal")
    public suspend fun apiCollectionId(`value`: Output<String>) {
        this.apiCollectionId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dnufiugibfjxfrsh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("gygtbpyyfpmtcpxq")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value A string representing the apiCollections resource within the Microsoft.Security provider namespace. This string matches the Azure API Management API name.
     */
    @JvmName("qrnhunaxmrwwhrpf")
    public suspend fun apiCollectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.apiCollectionId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("neloyymjhaurhfei")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the API Management service.
     */
    @JvmName("udqmpcycvwldflhm")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): APICollectionArgs = APICollectionArgs(
        apiCollectionId = apiCollectionId,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
    )
}
