@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.AdvancedThreatProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Advanced Threat Protection resource.
 * Azure REST API version: 2019-01-01. Prior API version in Azure Native 1.x: 2019-01-01.
 * ## Example Usage
 * ### Creates or updates the Advanced Threat Protection settings on a specified resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var advancedThreatProtection = new AzureNative.Security.AdvancedThreatProtection("advancedThreatProtection", new()
 *     {
 *         IsEnabled = true,
 *         ResourceId = "subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount",
 *         SettingName = "current",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAdvancedThreatProtection(ctx, "advancedThreatProtection", &security.AdvancedThreatProtectionArgs{
 * 			IsEnabled:   pulumi.Bool(true),
 * 			ResourceId:  pulumi.String("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount"),
 * 			SettingName: pulumi.String("current"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AdvancedThreatProtection;
 * import com.pulumi.azurenative.security.AdvancedThreatProtectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var advancedThreatProtection = new AdvancedThreatProtection("advancedThreatProtection", AdvancedThreatProtectionArgs.builder()
 *             .isEnabled(true)
 *             .resourceId("subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/SampleRG/providers/Microsoft.Storage/storageAccounts/samplestorageaccount")
 *             .settingName("current")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AdvancedThreatProtection current /{resourceId}/providers/Microsoft.Security/advancedThreatProtectionSettings/{settingName}
 * ```
 * @property isEnabled Indicates whether Advanced Threat Protection is enabled.
 * @property resourceId The identifier of the resource.
 * @property settingName Advanced Threat Protection setting name.
 */
public data class AdvancedThreatProtectionArgs(
    public val isEnabled: Output<Boolean>? = null,
    public val resourceId: Output<String>? = null,
    public val settingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.AdvancedThreatProtectionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.AdvancedThreatProtectionArgs =
        com.pulumi.azurenative.security.AdvancedThreatProtectionArgs.builder()
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .settingName(settingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdvancedThreatProtectionArgs].
 */
@PulumiTagMarker
public class AdvancedThreatProtectionArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var resourceId: Output<String>? = null

    private var settingName: Output<String>? = null

    /**
     * @param value Indicates whether Advanced Threat Protection is enabled.
     */
    @JvmName("ydcisukojweqxyey")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("lkxluphmpmevcoms")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Advanced Threat Protection setting name.
     */
    @JvmName("kkhjxuveqwbdnsxm")
    public suspend fun settingName(`value`: Output<String>) {
        this.settingName = value
    }

    /**
     * @param value Indicates whether Advanced Threat Protection is enabled.
     */
    @JvmName("pnrypagerhpyxvvo")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The identifier of the resource.
     */
    @JvmName("drvuhqjkbrxiubme")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value Advanced Threat Protection setting name.
     */
    @JvmName("qaalabpxuoojvprh")
    public suspend fun settingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settingName = mapped
    }

    internal fun build(): AdvancedThreatProtectionArgs = AdvancedThreatProtectionArgs(
        isEnabled = isEnabled,
        resourceId = resourceId,
        settingName = settingName,
    )
}
