@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [AssessmentsMetadataSubscription].
 */
@PulumiTagMarker
public class AssessmentsMetadataSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AssessmentsMetadataSubscriptionArgs = AssessmentsMetadataSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AssessmentsMetadataSubscriptionArgsBuilder.() -> Unit) {
        val builder = AssessmentsMetadataSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AssessmentsMetadataSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.security.AssessmentsMetadataSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AssessmentsMetadataSubscription(builtJavaResource)
    }
}

/**
 * Security assessment metadata
 * Azure REST API version: 2019-01-01-preview.
 * ## Example Usage
 * ### Create security assessment metadata for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assessmentsMetadataSubscription = new AzureNative.Security.AssessmentsMetadataSubscription("assessmentsMetadataSubscription", new()
 *     {
 *         AssessmentMetadataName = "ca039e75-a276-4175-aebc-bcd41e4b14b7",
 *         AssessmentType = "CustomerManaged",
 *         Categories = new[]
 *         {
 *             "Compute",
 *         },
 *         Description = "Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.",
 *         DisplayName = "Install endpoint protection solution on virtual machine scale sets",
 *         ImplementationEffort = "Low",
 *         RemediationDescription = "To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>",
 *         Severity = "Medium",
 *         Threats = new[]
 *         {
 *             "dataExfiltration",
 *             "dataSpillage",
 *             "maliciousInsider",
 *         },
 *         UserImpact = "Low",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewAssessmentsMetadataSubscription(ctx, "assessmentsMetadataSubscription", &security.AssessmentsMetadataSubscriptionArgs{
 * 			AssessmentMetadataName: pulumi.String("ca039e75-a276-4175-aebc-bcd41e4b14b7"),
 * 			AssessmentType:         pulumi.String("CustomerManaged"),
 * 			Categories: pulumi.StringArray{
 * 				pulumi.String("Compute"),
 * 			},
 * 			Description:            pulumi.String("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities."),
 * 			DisplayName:            pulumi.String("Install endpoint protection solution on virtual machine scale sets"),
 * 			ImplementationEffort:   pulumi.String("Low"),
 * 			RemediationDescription: pulumi.String("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>"),
 * 			Severity:               pulumi.String("Medium"),
 * 			Threats: pulumi.StringArray{
 * 				pulumi.String("dataExfiltration"),
 * 				pulumi.String("dataSpillage"),
 * 				pulumi.String("maliciousInsider"),
 * 			},
 * 			UserImpact: pulumi.String("Low"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.AssessmentsMetadataSubscription;
 * import com.pulumi.azurenative.security.AssessmentsMetadataSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assessmentsMetadataSubscription = new AssessmentsMetadataSubscription("assessmentsMetadataSubscription", AssessmentsMetadataSubscriptionArgs.builder()
 *             .assessmentMetadataName("ca039e75-a276-4175-aebc-bcd41e4b14b7")
 *             .assessmentType("CustomerManaged")
 *             .categories("Compute")
 *             .description("Install an endpoint protection solution on your virtual machines scale sets, to protect them from threats and vulnerabilities.")
 *             .displayName("Install endpoint protection solution on virtual machine scale sets")
 *             .implementationEffort("Low")
 *             .remediationDescription("To install an endpoint protection solution: 1.  <a href=\"https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-faq#how-do-i-turn-on-antimalware-in-my-virtual-machine-scale-set\">Follow the instructions in How do I turn on antimalware in my virtual machine scale set</a>")
 *             .severity("Medium")
 *             .threats(
 *                 "dataExfiltration",
 *                 "dataSpillage",
 *                 "maliciousInsider")
 *             .userImpact("Low")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:AssessmentsMetadataSubscription ca039e75-a276-4175-aebc-bcd41e4b14b7 /subscriptions/{subscriptionId}/providers/Microsoft.Security/assessmentMetadata/{assessmentMetadataName}
 * ```
 */
public class AssessmentsMetadataSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.security.AssessmentsMetadataSubscription,
) : KotlinCustomResource(javaResource, AssessmentsMetadataSubscriptionMapper) {
    /**
     * BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
     */
    public val assessmentType: Output<String>
        get() = javaResource.assessmentType().applyValue({ args0 -> args0 })

    public val categories: Output<List<String>>?
        get() = javaResource.categories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Human readable description of the assessment
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User friendly display name of the assessment
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * The implementation effort required to remediate this assessment
     */
    public val implementationEffort: Output<String>?
        get() = javaResource.implementationEffort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure resource ID of the policy definition that turns this assessment calculation on
     */
    public val policyDefinitionId: Output<String>
        get() = javaResource.policyDefinitionId().applyValue({ args0 -> args0 })

    /**
     * True if this assessment is in preview release status
     */
    public val preview: Output<Boolean>?
        get() = javaResource.preview().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Human readable description of what you should do to mitigate this security issue
     */
    public val remediationDescription: Output<String>?
        get() = javaResource.remediationDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The severity level of the assessment
     */
    public val severity: Output<String>
        get() = javaResource.severity().applyValue({ args0 -> args0 })

    public val threats: Output<List<String>>?
        get() = javaResource.threats().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user impact of the assessment
     */
    public val userImpact: Output<String>?
        get() = javaResource.userImpact().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object AssessmentsMetadataSubscriptionMapper :
    ResourceMapper<AssessmentsMetadataSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.AssessmentsMetadataSubscription::class == javaResource::class

    override fun map(javaResource: Resource): AssessmentsMetadataSubscription =
        AssessmentsMetadataSubscription(
            javaResource as
                com.pulumi.azurenative.security.AssessmentsMetadataSubscription,
        )
}

/**
 * @see [AssessmentsMetadataSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AssessmentsMetadataSubscription].
 */
public suspend fun assessmentsMetadataSubscription(
    name: String,
    block: suspend AssessmentsMetadataSubscriptionResourceBuilder.() -> Unit,
):
    AssessmentsMetadataSubscription {
    val builder = AssessmentsMetadataSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AssessmentsMetadataSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun assessmentsMetadataSubscription(name: String): AssessmentsMetadataSubscription {
    val builder = AssessmentsMetadataSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
