@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.HybridComputeSettingsPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.HybridComputeSettingsPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.azurenative.security.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * The connector setting
 * Azure REST API version: 2020-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### AwsAssumeRole - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs
 *         {
 *             AuthenticationType = "awsAssumeRole",
 *             AwsAssumeRoleArn = "arn:aws:iam::81231569658:role/AscConnector",
 *             AwsExternalId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         },
 *         ConnectorName = "aws_dev2",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "On",
 *             ProxyServer = new AzureNative.Security.Inputs.ProxyServerPropertiesArgs
 *             {
 *                 Ip = "167.220.197.140",
 *                 Port = "34",
 *             },
 *             Region = "West US 2",
 *             ResourceGroupName = "AwsConnectorRG",
 *             ServicePrincipal = new AzureNative.Security.Inputs.ServicePrincipalPropertiesArgs
 *             {
 *                 ApplicationId = "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1",
 *                 Secret = "<secret>",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.AwAssumeRoleAuthenticationDetailsProperties{
 * 				AuthenticationType: "awsAssumeRole",
 * 				AwsAssumeRoleArn:   "arn:aws:iam::81231569658:role/AscConnector",
 * 				AwsExternalId:      "20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 * 			},
 * 			ConnectorName: pulumi.String("aws_dev2"),
 * 			HybridComputeSettings: security.HybridComputeSettingsPropertiesResponse{
 * 				AutoProvision: pulumi.String("On"),
 * 				ProxyServer: &security.ProxyServerPropertiesArgs{
 * 					Ip:   pulumi.String("167.220.197.140"),
 * 					Port: pulumi.String("34"),
 * 				},
 * 				Region:            pulumi.String("West US 2"),
 * 				ResourceGroupName: pulumi.String("AwsConnectorRG"),
 * 				ServicePrincipal: &security.ServicePrincipalPropertiesArgs{
 * 					ApplicationId: pulumi.String("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 * 					Secret:        pulumi.String("<secret>"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authenticationType", "awsAssumeRole"),
 *                 Map.entry("awsAssumeRoleArn", "arn:aws:iam::81231569658:role/AscConnector"),
 *                 Map.entry("awsExternalId", "20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             ))
 *             .connectorName("aws_dev2")
 *             .hybridComputeSettings(Map.ofEntries(
 *                 Map.entry("autoProvision", "On"),
 *                 Map.entry("proxyServer", Map.ofEntries(
 *                     Map.entry("ip", "167.220.197.140"),
 *                     Map.entry("port", "34")
 *                 )),
 *                 Map.entry("region", "West US 2"),
 *                 Map.entry("resourceGroupName", "AwsConnectorRG"),
 *                 Map.entry("servicePrincipal", Map.ofEntries(
 *                     Map.entry("applicationId", "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 *                     Map.entry("secret", "<secret>")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### AwsCred - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.AwsCredsAuthenticationDetailsPropertiesArgs
 *         {
 *             AuthenticationType = "awsCreds",
 *             AwsAccessKeyId = "AKIARPZCNODDNAEQFSOE",
 *             AwsSecretAccessKey = "<awsSecretAccessKey>",
 *         },
 *         ConnectorName = "aws_dev1",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "On",
 *             ProxyServer = new AzureNative.Security.Inputs.ProxyServerPropertiesArgs
 *             {
 *                 Ip = "167.220.197.140",
 *                 Port = "34",
 *             },
 *             Region = "West US 2",
 *             ResourceGroupName = "AwsConnectorRG",
 *             ServicePrincipal = new AzureNative.Security.Inputs.ServicePrincipalPropertiesArgs
 *             {
 *                 ApplicationId = "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1",
 *                 Secret = "<secret>",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.AwsCredsAuthenticationDetailsProperties{
 * 				AuthenticationType: "awsCreds",
 * 				AwsAccessKeyId:     "AKIARPZCNODDNAEQFSOE",
 * 				AwsSecretAccessKey: "<awsSecretAccessKey>",
 * 			},
 * 			ConnectorName: pulumi.String("aws_dev1"),
 * 			HybridComputeSettings: security.HybridComputeSettingsPropertiesResponse{
 * 				AutoProvision: pulumi.String("On"),
 * 				ProxyServer: &security.ProxyServerPropertiesArgs{
 * 					Ip:   pulumi.String("167.220.197.140"),
 * 					Port: pulumi.String("34"),
 * 				},
 * 				Region:            pulumi.String("West US 2"),
 * 				ResourceGroupName: pulumi.String("AwsConnectorRG"),
 * 				ServicePrincipal: &security.ServicePrincipalPropertiesArgs{
 * 					ApplicationId: pulumi.String("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 * 					Secret:        pulumi.String("<secret>"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authenticationType", "awsCreds"),
 *                 Map.entry("awsAccessKeyId", "AKIARPZCNODDNAEQFSOE"),
 *                 Map.entry("awsSecretAccessKey", "<awsSecretAccessKey>")
 *             ))
 *             .connectorName("aws_dev1")
 *             .hybridComputeSettings(Map.ofEntries(
 *                 Map.entry("autoProvision", "On"),
 *                 Map.entry("proxyServer", Map.ofEntries(
 *                     Map.entry("ip", "167.220.197.140"),
 *                     Map.entry("port", "34")
 *                 )),
 *                 Map.entry("region", "West US 2"),
 *                 Map.entry("resourceGroupName", "AwsConnectorRG"),
 *                 Map.entry("servicePrincipal", Map.ofEntries(
 *                     Map.entry("applicationId", "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 *                     Map.entry("secret", "<secret>")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### gcpCredentials - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.GcpCredentialsDetailsPropertiesArgs
 *         {
 *             AuthProviderX509CertUrl = "https://www.googleapis.com/oauth2/v1/certs",
 *             AuthUri = "https://accounts.google.com/o/oauth2/auth",
 *             AuthenticationType = "gcpCredentials",
 *             ClientEmail = "asc-135@asc-project-1234.iam.gserviceaccount.com",
 *             ClientId = "105889053725632919854",
 *             ClientX509CertUrl = "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com",
 *             OrganizationId = "AscDemoOrg",
 *             PrivateKey = "******",
 *             PrivateKeyId = "6efg587hra2568as34d22326b044cc20dc2af",
 *             ProjectId = "asc-project-1234",
 *             TokenUri = "https://oauth2.googleapis.com/token",
 *             Type = "service_account",
 *         },
 *         ConnectorName = "gcp_dev",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "Off",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.GcpCredentialsDetailsProperties{
 * 				AuthProviderX509CertUrl: "https://www.googleapis.com/oauth2/v1/certs",
 * 				AuthUri:                 "https://accounts.google.com/o/oauth2/auth",
 * 				AuthenticationType:      "gcpCredentials",
 * 				ClientEmail:             "asc-135@asc-project-1234.iam.gserviceaccount.com",
 * 				ClientId:                "105889053725632919854",
 * 				ClientX509CertUrl:       "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com",
 * 				OrganizationId:          "AscDemoOrg",
 * 				PrivateKey:              "******",
 * 				PrivateKeyId:            "6efg587hra2568as34d22326b044cc20dc2af",
 * 				ProjectId:               "asc-project-1234",
 * 				TokenUri:                "https://oauth2.googleapis.com/token",
 * 				Type:                    "service_account",
 * 			},
 * 			ConnectorName: pulumi.String("gcp_dev"),
 * 			HybridComputeSettings: &security.HybridComputeSettingsPropertiesArgs{
 * 				AutoProvision: pulumi.String("Off"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authProviderX509CertUrl", "https://www.googleapis.com/oauth2/v1/certs"),
 *                 Map.entry("authUri", "https://accounts.google.com/o/oauth2/auth"),
 *                 Map.entry("authenticationType", "gcpCredentials"),
 *                 Map.entry("clientEmail", "asc-135@asc-project-1234.iam.gserviceaccount.com"),
 *                 Map.entry("clientId", "105889053725632919854"),
 *                 Map.entry("clientX509CertUrl", "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com"),
 *                 Map.entry("organizationId", "AscDemoOrg"),
 *                 Map.entry("privateKey", "******"),
 *                 Map.entry("privateKeyId", "6efg587hra2568as34d22326b044cc20dc2af"),
 *                 Map.entry("projectId", "asc-project-1234"),
 *                 Map.entry("tokenUri", "https://oauth2.googleapis.com/token"),
 *                 Map.entry("type", "service_account")
 *             ))
 *             .connectorName("gcp_dev")
 *             .hybridComputeSettings(Map.of("autoProvision", "Off"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Connector gcp_dev /subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.azurenative.security.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * Settings for authentication management, these settings are relevant only for the cloud connector.
     */
    public val authenticationDetails: Output<Any>?
        get() = javaResource.authenticationDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
     */
    public val hybridComputeSettings: Output<HybridComputeSettingsPropertiesResponse>?
        get() = javaResource.hybridComputeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.azurenative.security.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit):
    Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
