@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.ConnectorArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.HybridComputeSettingsPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.HybridComputeSettingsPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The connector setting
 * Azure REST API version: 2020-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * ## Example Usage
 * ### AwsAssumeRole - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.AwAssumeRoleAuthenticationDetailsPropertiesArgs
 *         {
 *             AuthenticationType = "awsAssumeRole",
 *             AwsAssumeRoleArn = "arn:aws:iam::81231569658:role/AscConnector",
 *             AwsExternalId = "20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         },
 *         ConnectorName = "aws_dev2",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "On",
 *             ProxyServer = new AzureNative.Security.Inputs.ProxyServerPropertiesArgs
 *             {
 *                 Ip = "167.220.197.140",
 *                 Port = "34",
 *             },
 *             Region = "West US 2",
 *             ResourceGroupName = "AwsConnectorRG",
 *             ServicePrincipal = new AzureNative.Security.Inputs.ServicePrincipalPropertiesArgs
 *             {
 *                 ApplicationId = "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1",
 *                 Secret = "<secret>",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.AwAssumeRoleAuthenticationDetailsProperties{
 * 				AuthenticationType: "awsAssumeRole",
 * 				AwsAssumeRoleArn:   "arn:aws:iam::81231569658:role/AscConnector",
 * 				AwsExternalId:      "20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 * 			},
 * 			ConnectorName: pulumi.String("aws_dev2"),
 * 			HybridComputeSettings: security.HybridComputeSettingsPropertiesResponse{
 * 				AutoProvision: pulumi.String("On"),
 * 				ProxyServer: &security.ProxyServerPropertiesArgs{
 * 					Ip:   pulumi.String("167.220.197.140"),
 * 					Port: pulumi.String("34"),
 * 				},
 * 				Region:            pulumi.String("West US 2"),
 * 				ResourceGroupName: pulumi.String("AwsConnectorRG"),
 * 				ServicePrincipal: &security.ServicePrincipalPropertiesArgs{
 * 					ApplicationId: pulumi.String("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 * 					Secret:        pulumi.String("<secret>"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authenticationType", "awsAssumeRole"),
 *                 Map.entry("awsAssumeRoleArn", "arn:aws:iam::81231569658:role/AscConnector"),
 *                 Map.entry("awsExternalId", "20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             ))
 *             .connectorName("aws_dev2")
 *             .hybridComputeSettings(Map.ofEntries(
 *                 Map.entry("autoProvision", "On"),
 *                 Map.entry("proxyServer", Map.ofEntries(
 *                     Map.entry("ip", "167.220.197.140"),
 *                     Map.entry("port", "34")
 *                 )),
 *                 Map.entry("region", "West US 2"),
 *                 Map.entry("resourceGroupName", "AwsConnectorRG"),
 *                 Map.entry("servicePrincipal", Map.ofEntries(
 *                     Map.entry("applicationId", "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 *                     Map.entry("secret", "<secret>")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### AwsCred - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.AwsCredsAuthenticationDetailsPropertiesArgs
 *         {
 *             AuthenticationType = "awsCreds",
 *             AwsAccessKeyId = "AKIARPZCNODDNAEQFSOE",
 *             AwsSecretAccessKey = "<awsSecretAccessKey>",
 *         },
 *         ConnectorName = "aws_dev1",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "On",
 *             ProxyServer = new AzureNative.Security.Inputs.ProxyServerPropertiesArgs
 *             {
 *                 Ip = "167.220.197.140",
 *                 Port = "34",
 *             },
 *             Region = "West US 2",
 *             ResourceGroupName = "AwsConnectorRG",
 *             ServicePrincipal = new AzureNative.Security.Inputs.ServicePrincipalPropertiesArgs
 *             {
 *                 ApplicationId = "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1",
 *                 Secret = "<secret>",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.AwsCredsAuthenticationDetailsProperties{
 * 				AuthenticationType: "awsCreds",
 * 				AwsAccessKeyId:     "AKIARPZCNODDNAEQFSOE",
 * 				AwsSecretAccessKey: "<awsSecretAccessKey>",
 * 			},
 * 			ConnectorName: pulumi.String("aws_dev1"),
 * 			HybridComputeSettings: security.HybridComputeSettingsPropertiesResponse{
 * 				AutoProvision: pulumi.String("On"),
 * 				ProxyServer: &security.ProxyServerPropertiesArgs{
 * 					Ip:   pulumi.String("167.220.197.140"),
 * 					Port: pulumi.String("34"),
 * 				},
 * 				Region:            pulumi.String("West US 2"),
 * 				ResourceGroupName: pulumi.String("AwsConnectorRG"),
 * 				ServicePrincipal: &security.ServicePrincipalPropertiesArgs{
 * 					ApplicationId: pulumi.String("ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 * 					Secret:        pulumi.String("<secret>"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authenticationType", "awsCreds"),
 *                 Map.entry("awsAccessKeyId", "AKIARPZCNODDNAEQFSOE"),
 *                 Map.entry("awsSecretAccessKey", "<awsSecretAccessKey>")
 *             ))
 *             .connectorName("aws_dev1")
 *             .hybridComputeSettings(Map.ofEntries(
 *                 Map.entry("autoProvision", "On"),
 *                 Map.entry("proxyServer", Map.ofEntries(
 *                     Map.entry("ip", "167.220.197.140"),
 *                     Map.entry("port", "34")
 *                 )),
 *                 Map.entry("region", "West US 2"),
 *                 Map.entry("resourceGroupName", "AwsConnectorRG"),
 *                 Map.entry("servicePrincipal", Map.ofEntries(
 *                     Map.entry("applicationId", "ad9bcd79-be9c-45ab-abd8-80ca1654a7d1"),
 *                     Map.entry("secret", "<secret>")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### gcpCredentials - Create a cloud account connector for a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new AzureNative.Security.Connector("connector", new()
 *     {
 *         AuthenticationDetails = new AzureNative.Security.Inputs.GcpCredentialsDetailsPropertiesArgs
 *         {
 *             AuthProviderX509CertUrl = "https://www.googleapis.com/oauth2/v1/certs",
 *             AuthUri = "https://accounts.google.com/o/oauth2/auth",
 *             AuthenticationType = "gcpCredentials",
 *             ClientEmail = "asc-135@asc-project-1234.iam.gserviceaccount.com",
 *             ClientId = "105889053725632919854",
 *             ClientX509CertUrl = "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com",
 *             OrganizationId = "AscDemoOrg",
 *             PrivateKey = "******",
 *             PrivateKeyId = "6efg587hra2568as34d22326b044cc20dc2af",
 *             ProjectId = "asc-project-1234",
 *             TokenUri = "https://oauth2.googleapis.com/token",
 *             Type = "service_account",
 *         },
 *         ConnectorName = "gcp_dev",
 *         HybridComputeSettings = new AzureNative.Security.Inputs.HybridComputeSettingsPropertiesArgs
 *         {
 *             AutoProvision = "Off",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewConnector(ctx, "connector", &security.ConnectorArgs{
 * 			AuthenticationDetails: security.GcpCredentialsDetailsProperties{
 * 				AuthProviderX509CertUrl: "https://www.googleapis.com/oauth2/v1/certs",
 * 				AuthUri:                 "https://accounts.google.com/o/oauth2/auth",
 * 				AuthenticationType:      "gcpCredentials",
 * 				ClientEmail:             "asc-135@asc-project-1234.iam.gserviceaccount.com",
 * 				ClientId:                "105889053725632919854",
 * 				ClientX509CertUrl:       "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com",
 * 				OrganizationId:          "AscDemoOrg",
 * 				PrivateKey:              "******",
 * 				PrivateKeyId:            "6efg587hra2568as34d22326b044cc20dc2af",
 * 				ProjectId:               "asc-project-1234",
 * 				TokenUri:                "https://oauth2.googleapis.com/token",
 * 				Type:                    "service_account",
 * 			},
 * 			ConnectorName: pulumi.String("gcp_dev"),
 * 			HybridComputeSettings: &security.HybridComputeSettingsPropertiesArgs{
 * 				AutoProvision: pulumi.String("Off"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.Connector;
 * import com.pulumi.azurenative.security.ConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new Connector("connector", ConnectorArgs.builder()
 *             .authenticationDetails(Map.ofEntries(
 *                 Map.entry("authProviderX509CertUrl", "https://www.googleapis.com/oauth2/v1/certs"),
 *                 Map.entry("authUri", "https://accounts.google.com/o/oauth2/auth"),
 *                 Map.entry("authenticationType", "gcpCredentials"),
 *                 Map.entry("clientEmail", "asc-135@asc-project-1234.iam.gserviceaccount.com"),
 *                 Map.entry("clientId", "105889053725632919854"),
 *                 Map.entry("clientX509CertUrl", "https://www.googleapis.com/robot/v1/metadata/x509/asc-135%40asc-project-1234.iam.gserviceaccount.com"),
 *                 Map.entry("organizationId", "AscDemoOrg"),
 *                 Map.entry("privateKey", "******"),
 *                 Map.entry("privateKeyId", "6efg587hra2568as34d22326b044cc20dc2af"),
 *                 Map.entry("projectId", "asc-project-1234"),
 *                 Map.entry("tokenUri", "https://oauth2.googleapis.com/token"),
 *                 Map.entry("type", "service_account")
 *             ))
 *             .connectorName("gcp_dev")
 *             .hybridComputeSettings(Map.of("autoProvision", "Off"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:Connector gcp_dev /subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}
 * ```
 * @property authenticationDetails Settings for authentication management, these settings are relevant only for the cloud connector.
 * @property connectorName Name of the cloud account connector
 * @property hybridComputeSettings Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
 */
public data class ConnectorArgs(
    public val authenticationDetails: Output<Any>? = null,
    public val connectorName: Output<String>? = null,
    public val hybridComputeSettings: Output<HybridComputeSettingsPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.ConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.security.ConnectorArgs =
        com.pulumi.azurenative.security.ConnectorArgs.builder()
            .authenticationDetails(authenticationDetails?.applyValue({ args0 -> args0 }))
            .connectorName(connectorName?.applyValue({ args0 -> args0 }))
            .hybridComputeSettings(
                hybridComputeSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectorArgs].
 */
@PulumiTagMarker
public class ConnectorArgsBuilder internal constructor() {
    private var authenticationDetails: Output<Any>? = null

    private var connectorName: Output<String>? = null

    private var hybridComputeSettings: Output<HybridComputeSettingsPropertiesArgs>? = null

    /**
     * @param value Settings for authentication management, these settings are relevant only for the cloud connector.
     */
    @JvmName("bbcxxtlxatgirlbf")
    public suspend fun authenticationDetails(`value`: Output<Any>) {
        this.authenticationDetails = value
    }

    /**
     * @param value Name of the cloud account connector
     */
    @JvmName("tasjoahhrhgomleb")
    public suspend fun connectorName(`value`: Output<String>) {
        this.connectorName = value
    }

    /**
     * @param value Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
     */
    @JvmName("ppsenekyvbpixjnw")
    public suspend fun hybridComputeSettings(`value`: Output<HybridComputeSettingsPropertiesArgs>) {
        this.hybridComputeSettings = value
    }

    /**
     * @param value Settings for authentication management, these settings are relevant only for the cloud connector.
     */
    @JvmName("mmyjpwyicdsiabey")
    public suspend fun authenticationDetails(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationDetails = mapped
    }

    /**
     * @param value Name of the cloud account connector
     */
    @JvmName("inmpnxkirwmlaxor")
    public suspend fun connectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectorName = mapped
    }

    /**
     * @param value Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
     */
    @JvmName("gjvduktiodcalwyv")
    public suspend fun hybridComputeSettings(`value`: HybridComputeSettingsPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridComputeSettings = mapped
    }

    /**
     * @param argument Settings for hybrid compute management. These settings are relevant only for Arc autoProvision (Hybrid Compute).
     */
    @JvmName("vfrrcbrqbjaexgdt")
    public suspend
    fun hybridComputeSettings(argument: suspend HybridComputeSettingsPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = HybridComputeSettingsPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hybridComputeSettings = mapped
    }

    internal fun build(): ConnectorArgs = ConnectorArgs(
        authenticationDetails = authenticationDetails,
        connectorName = connectorName,
        hybridComputeSettings = hybridComputeSettings,
    )
}
