@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomEntityStoreAssignment].
 */
@PulumiTagMarker
public class CustomEntityStoreAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomEntityStoreAssignmentArgs = CustomEntityStoreAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomEntityStoreAssignmentArgsBuilder.() -> Unit) {
        val builder = CustomEntityStoreAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomEntityStoreAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.security.CustomEntityStoreAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomEntityStoreAssignment(builtJavaResource)
    }
}

/**
 * Custom entity store assignment
 * Azure REST API version: 2021-07-01-preview. Prior API version in Azure Native 1.x: 2021-07-01-preview.
 * ## Example Usage
 * ### Create a custom entity store assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customEntityStoreAssignment = new AzureNative.Security.CustomEntityStoreAssignment("customEntityStoreAssignment", new()
 *     {
 *         CustomEntityStoreAssignmentName = "33e7cc6e-a139-4723-a0e5-76993aee0771",
 *         Principal = "aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47",
 *         ResourceGroupName = "TestResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewCustomEntityStoreAssignment(ctx, "customEntityStoreAssignment", &security.CustomEntityStoreAssignmentArgs{
 * 			CustomEntityStoreAssignmentName: pulumi.String("33e7cc6e-a139-4723-a0e5-76993aee0771"),
 * 			Principal:                       pulumi.String("aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 			ResourceGroupName:               pulumi.String("TestResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.CustomEntityStoreAssignment;
 * import com.pulumi.azurenative.security.CustomEntityStoreAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customEntityStoreAssignment = new CustomEntityStoreAssignment("customEntityStoreAssignment", CustomEntityStoreAssignmentArgs.builder()
 *             .customEntityStoreAssignmentName("33e7cc6e-a139-4723-a0e5-76993aee0771")
 *             .principal("aaduser=f3923a3e-ad57-4752-b1a9-fbf3c8e5e082;72f988bf-86f1-41af-91ab-2d7cd011db47")
 *             .resourceGroupName("TestResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:CustomEntityStoreAssignment 33e7cc6e-a139-4723-a0e5-76993aee0771 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Security/customEntityStoreAssignments/{customEntityStoreAssignmentName}
 * ```
 */
public class CustomEntityStoreAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.security.CustomEntityStoreAssignment,
) : KotlinCustomResource(javaResource, CustomEntityStoreAssignmentMapper) {
    /**
     * The link to entity store database.
     */
    public val entityStoreDatabaseLink: Output<String>?
        get() = javaResource.entityStoreDatabaseLink().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The principal assigned with entity store. Format of principal is: [AAD type]=[PrincipalObjectId];[TenantId]
     */
    public val principal: Output<String>?
        get() = javaResource.principal().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomEntityStoreAssignmentMapper : ResourceMapper<CustomEntityStoreAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.CustomEntityStoreAssignment::class == javaResource::class

    override fun map(javaResource: Resource): CustomEntityStoreAssignment =
        CustomEntityStoreAssignment(
            javaResource as
                com.pulumi.azurenative.security.CustomEntityStoreAssignment,
        )
}

/**
 * @see [CustomEntityStoreAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomEntityStoreAssignment].
 */
public suspend fun customEntityStoreAssignment(
    name: String,
    block: suspend CustomEntityStoreAssignmentResourceBuilder.() -> Unit,
):
    CustomEntityStoreAssignment {
    val builder = CustomEntityStoreAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomEntityStoreAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customEntityStoreAssignment(name: String): CustomEntityStoreAssignment {
    val builder = CustomEntityStoreAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
