@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.IotSecuritySolutionArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.DataSource
import com.pulumi.azurenative.security.kotlin.enums.ExportData
import com.pulumi.azurenative.security.kotlin.enums.SecuritySolutionStatus
import com.pulumi.azurenative.security.kotlin.enums.UnmaskedIpLoggingStatus
import com.pulumi.azurenative.security.kotlin.inputs.AdditionalWorkspacesPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.AdditionalWorkspacesPropertiesArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.RecommendationConfigurationPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.RecommendationConfigurationPropertiesArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.UserDefinedResourcesPropertiesArgs
import com.pulumi.azurenative.security.kotlin.inputs.UserDefinedResourcesPropertiesArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * IoT Security solution configuration and resource information.
 * Azure REST API version: 2019-08-01. Prior API version in Azure Native 1.x: 2019-08-01.
 * Other available API versions: 2017-08-01-preview.
 * ## Example Usage
 * ### Create or update a IoT security solution
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iotSecuritySolution = new AzureNative.Security.IotSecuritySolution("iotSecuritySolution", new()
 *     {
 *         DisabledDataSources = new[] {},
 *         DisplayName = "Solution Default",
 *         Export = new[] {},
 *         IotHubs = new[]
 *         {
 *             "/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub",
 *         },
 *         Location = "East Us",
 *         RecommendationsConfiguration = new[]
 *         {
 *             new AzureNative.Security.Inputs.RecommendationConfigurationPropertiesArgs
 *             {
 *                 RecommendationType = "IoT_OpenPorts",
 *                 Status = "Disabled",
 *             },
 *             new AzureNative.Security.Inputs.RecommendationConfigurationPropertiesArgs
 *             {
 *                 RecommendationType = "IoT_SharedCredentials",
 *                 Status = "Disabled",
 *             },
 *         },
 *         ResourceGroupName = "MyGroup",
 *         SolutionName = "default",
 *         Status = "Enabled",
 *         Tags = null,
 *         UnmaskedIpLoggingStatus = "Enabled",
 *         UserDefinedResources = new AzureNative.Security.Inputs.UserDefinedResourcesPropertiesArgs
 *         {
 *             Query = "where type != \"microsoft.devices/iothubs\" | where name contains \"iot\"",
 *             QuerySubscriptions = new[]
 *             {
 *                 "075423e9-7d33-4166-8bdf-3920b04e3735",
 *             },
 *         },
 *         Workspace = "/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewIotSecuritySolution(ctx, "iotSecuritySolution", &security.IotSecuritySolutionArgs{
 * 			DisabledDataSources: pulumi.StringArray{},
 * 			DisplayName:         pulumi.String("Solution Default"),
 * 			Export:              pulumi.StringArray{},
 * 			IotHubs: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub"),
 * 			},
 * 			Location: pulumi.String("East Us"),
 * 			RecommendationsConfiguration: []security.RecommendationConfigurationPropertiesArgs{
 * 				{
 * 					RecommendationType: pulumi.String("IoT_OpenPorts"),
 * 					Status:             pulumi.String("Disabled"),
 * 				},
 * 				{
 * 					RecommendationType: pulumi.String("IoT_SharedCredentials"),
 * 					Status:             pulumi.String("Disabled"),
 * 				},
 * 			},
 * 			ResourceGroupName:       pulumi.String("MyGroup"),
 * 			SolutionName:            pulumi.String("default"),
 * 			Status:                  pulumi.String("Enabled"),
 * 			Tags:                    nil,
 * 			UnmaskedIpLoggingStatus: pulumi.String("Enabled"),
 * 			UserDefinedResources: &security.UserDefinedResourcesPropertiesArgs{
 * 				Query: pulumi.String("where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
 * 				QuerySubscriptions: pulumi.StringArray{
 * 					pulumi.String("075423e9-7d33-4166-8bdf-3920b04e3735"),
 * 				},
 * 			},
 * 			Workspace: pulumi.String("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.IotSecuritySolution;
 * import com.pulumi.azurenative.security.IotSecuritySolutionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iotSecuritySolution = new IotSecuritySolution("iotSecuritySolution", IotSecuritySolutionArgs.builder()
 *             .disabledDataSources()
 *             .displayName("Solution Default")
 *             .export()
 *             .iotHubs("/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub")
 *             .location("East Us")
 *             .recommendationsConfiguration(
 *                 Map.ofEntries(
 *                     Map.entry("recommendationType", "IoT_OpenPorts"),
 *                     Map.entry("status", "Disabled")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("recommendationType", "IoT_SharedCredentials"),
 *                     Map.entry("status", "Disabled")
 *                 ))
 *             .resourceGroupName("MyGroup")
 *             .solutionName("default")
 *             .status("Enabled")
 *             .tags()
 *             .unmaskedIpLoggingStatus("Enabled")
 *             .userDefinedResources(Map.ofEntries(
 *                 Map.entry("query", "where type != \"microsoft.devices/iothubs\" | where name contains \"iot\""),
 *                 Map.entry("querySubscriptions", "075423e9-7d33-4166-8bdf-3920b04e3735")
 *             ))
 *             .workspace("/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:IotSecuritySolution default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/iotSecuritySolutions/{solutionName}
 * ```
 * @property additionalWorkspaces List of additional workspaces
 * @property disabledDataSources Disabled data sources. Disabling these data sources compromises the system.
 * @property displayName Resource display name.
 * @property export List of additional options for exporting to workspace data.
 * @property iotHubs IoT Hub resource IDs
 * @property location The resource location.
 * @property recommendationsConfiguration List of the configuration status for each recommendation type.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property solutionName The name of the IoT Security solution.
 * @property status Status of the IoT Security solution.
 * @property tags Resource tags
 * @property unmaskedIpLoggingStatus Unmasked IP address logging status
 * @property userDefinedResources Properties of the IoT Security solution's user defined resources.
 * @property workspace Workspace resource ID
 */
public data class IotSecuritySolutionArgs(
    public val additionalWorkspaces: Output<List<AdditionalWorkspacesPropertiesArgs>>? = null,
    public val disabledDataSources: Output<List<Either<String, DataSource>>>? = null,
    public val displayName: Output<String>? = null,
    public val export: Output<List<Either<String, ExportData>>>? = null,
    public val iotHubs: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val recommendationsConfiguration: Output<List<RecommendationConfigurationPropertiesArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val solutionName: Output<String>? = null,
    public val status: Output<Either<String, SecuritySolutionStatus>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val unmaskedIpLoggingStatus: Output<Either<String, UnmaskedIpLoggingStatus>>? = null,
    public val userDefinedResources: Output<UserDefinedResourcesPropertiesArgs>? = null,
    public val workspace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.IotSecuritySolutionArgs> {
    override fun toJava(): com.pulumi.azurenative.security.IotSecuritySolutionArgs =
        com.pulumi.azurenative.security.IotSecuritySolutionArgs.builder()
            .additionalWorkspaces(
                additionalWorkspaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .disabledDataSources(
                disabledDataSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .export(
                export?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .iotHubs(iotHubs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .recommendationsConfiguration(
                recommendationsConfiguration?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .solutionName(solutionName?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .unmaskedIpLoggingStatus(
                unmaskedIpLoggingStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .userDefinedResources(
                userDefinedResources?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspace(workspace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IotSecuritySolutionArgs].
 */
@PulumiTagMarker
public class IotSecuritySolutionArgsBuilder internal constructor() {
    private var additionalWorkspaces: Output<List<AdditionalWorkspacesPropertiesArgs>>? = null

    private var disabledDataSources: Output<List<Either<String, DataSource>>>? = null

    private var displayName: Output<String>? = null

    private var export: Output<List<Either<String, ExportData>>>? = null

    private var iotHubs: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var recommendationsConfiguration: Output<List<RecommendationConfigurationPropertiesArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var solutionName: Output<String>? = null

    private var status: Output<Either<String, SecuritySolutionStatus>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var unmaskedIpLoggingStatus: Output<Either<String, UnmaskedIpLoggingStatus>>? = null

    private var userDefinedResources: Output<UserDefinedResourcesPropertiesArgs>? = null

    private var workspace: Output<String>? = null

    /**
     * @param value List of additional workspaces
     */
    @JvmName("ftdvxnfttdrepadl")
    public suspend
    fun additionalWorkspaces(`value`: Output<List<AdditionalWorkspacesPropertiesArgs>>) {
        this.additionalWorkspaces = value
    }

    @JvmName("vqqvddmrfuhybwmy")
    public suspend fun additionalWorkspaces(
        vararg
        values: Output<AdditionalWorkspacesPropertiesArgs>,
    ) {
        this.additionalWorkspaces = Output.all(values.asList())
    }

    /**
     * @param values List of additional workspaces
     */
    @JvmName("ecfllbnftkhrlecj")
    public suspend
    fun additionalWorkspaces(values: List<Output<AdditionalWorkspacesPropertiesArgs>>) {
        this.additionalWorkspaces = Output.all(values)
    }

    /**
     * @param value Disabled data sources. Disabling these data sources compromises the system.
     */
    @JvmName("qfwlweejxxspgbcv")
    public suspend fun disabledDataSources(`value`: Output<List<Either<String, DataSource>>>) {
        this.disabledDataSources = value
    }

    @JvmName("uyppjfaudptdlgnr")
    public suspend fun disabledDataSources(vararg values: Output<Either<String, DataSource>>) {
        this.disabledDataSources = Output.all(values.asList())
    }

    /**
     * @param values Disabled data sources. Disabling these data sources compromises the system.
     */
    @JvmName("nyblfwytxjadelpd")
    public suspend fun disabledDataSources(values: List<Output<Either<String, DataSource>>>) {
        this.disabledDataSources = Output.all(values)
    }

    /**
     * @param value Resource display name.
     */
    @JvmName("ynumgcqfmhkhscbk")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value List of additional options for exporting to workspace data.
     */
    @JvmName("gkbinbhbvxixsmqg")
    public suspend fun export(`value`: Output<List<Either<String, ExportData>>>) {
        this.export = value
    }

    @JvmName("bffxsqixcynpjttm")
    public suspend fun export(vararg values: Output<Either<String, ExportData>>) {
        this.export = Output.all(values.asList())
    }

    /**
     * @param values List of additional options for exporting to workspace data.
     */
    @JvmName("gawvqjjgssadfwfi")
    public suspend fun export(values: List<Output<Either<String, ExportData>>>) {
        this.export = Output.all(values)
    }

    /**
     * @param value IoT Hub resource IDs
     */
    @JvmName("sxvqfwhgakwyfivf")
    public suspend fun iotHubs(`value`: Output<List<String>>) {
        this.iotHubs = value
    }

    @JvmName("rwcwaerenspikpsg")
    public suspend fun iotHubs(vararg values: Output<String>) {
        this.iotHubs = Output.all(values.asList())
    }

    /**
     * @param values IoT Hub resource IDs
     */
    @JvmName("ikenscnlajtacufm")
    public suspend fun iotHubs(values: List<Output<String>>) {
        this.iotHubs = Output.all(values)
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jkkwotfccvvgprbj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of the configuration status for each recommendation type.
     */
    @JvmName("gumtsncyuovtwidm")
    public suspend
    fun recommendationsConfiguration(`value`: Output<List<RecommendationConfigurationPropertiesArgs>>) {
        this.recommendationsConfiguration = value
    }

    @JvmName("gdgtcjiboytjjalv")
    public suspend fun recommendationsConfiguration(
        vararg
        values: Output<RecommendationConfigurationPropertiesArgs>,
    ) {
        this.recommendationsConfiguration = Output.all(values.asList())
    }

    /**
     * @param values List of the configuration status for each recommendation type.
     */
    @JvmName("qsimeikvtenmefiu")
    public suspend
    fun recommendationsConfiguration(values: List<Output<RecommendationConfigurationPropertiesArgs>>) {
        this.recommendationsConfiguration = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("renaseegydkhhehm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the IoT Security solution.
     */
    @JvmName("elhmwaoartkjxcqo")
    public suspend fun solutionName(`value`: Output<String>) {
        this.solutionName = value
    }

    /**
     * @param value Status of the IoT Security solution.
     */
    @JvmName("rwwwrwjvfpuxqjmm")
    public suspend fun status(`value`: Output<Either<String, SecuritySolutionStatus>>) {
        this.status = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("uyyqvgbuptwglsdn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Unmasked IP address logging status
     */
    @JvmName("xdhgtunrjiojdofp")
    public suspend
    fun unmaskedIpLoggingStatus(`value`: Output<Either<String, UnmaskedIpLoggingStatus>>) {
        this.unmaskedIpLoggingStatus = value
    }

    /**
     * @param value Properties of the IoT Security solution's user defined resources.
     */
    @JvmName("skjhbfciulhuvqhi")
    public suspend fun userDefinedResources(`value`: Output<UserDefinedResourcesPropertiesArgs>) {
        this.userDefinedResources = value
    }

    /**
     * @param value Workspace resource ID
     */
    @JvmName("ujeyifdejwkichnh")
    public suspend fun workspace(`value`: Output<String>) {
        this.workspace = value
    }

    /**
     * @param value List of additional workspaces
     */
    @JvmName("pgrtrfvycqxtjaur")
    public suspend fun additionalWorkspaces(`value`: List<AdditionalWorkspacesPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalWorkspaces = mapped
    }

    /**
     * @param argument List of additional workspaces
     */
    @JvmName("ewlgqffgprkwceiq")
    public suspend
    fun additionalWorkspaces(argument: List<suspend AdditionalWorkspacesPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AdditionalWorkspacesPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalWorkspaces = mapped
    }

    /**
     * @param argument List of additional workspaces
     */
    @JvmName("wivcaycvnxlburte")
    public suspend fun additionalWorkspaces(
        vararg
        argument: suspend AdditionalWorkspacesPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AdditionalWorkspacesPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalWorkspaces = mapped
    }

    /**
     * @param argument List of additional workspaces
     */
    @JvmName("yhoxnnyexgnciluu")
    public suspend
    fun additionalWorkspaces(argument: suspend AdditionalWorkspacesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AdditionalWorkspacesPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.additionalWorkspaces = mapped
    }

    /**
     * @param values List of additional workspaces
     */
    @JvmName("djxkvkppqscuypdn")
    public suspend fun additionalWorkspaces(vararg values: AdditionalWorkspacesPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalWorkspaces = mapped
    }

    /**
     * @param value Disabled data sources. Disabling these data sources compromises the system.
     */
    @JvmName("jphrbvqqlhlffwhv")
    public suspend fun disabledDataSources(`value`: List<Either<String, DataSource>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledDataSources = mapped
    }

    /**
     * @param values Disabled data sources. Disabling these data sources compromises the system.
     */
    @JvmName("pafdsayfruhlqxdp")
    public suspend fun disabledDataSources(vararg values: Either<String, DataSource>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledDataSources = mapped
    }

    /**
     * @param value Resource display name.
     */
    @JvmName("ykbdcuempdahjfir")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value List of additional options for exporting to workspace data.
     */
    @JvmName("ktihvtmhyhbyppcm")
    public suspend fun export(`value`: List<Either<String, ExportData>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.export = mapped
    }

    /**
     * @param values List of additional options for exporting to workspace data.
     */
    @JvmName("lugofakypjnsktre")
    public suspend fun export(vararg values: Either<String, ExportData>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.export = mapped
    }

    /**
     * @param value IoT Hub resource IDs
     */
    @JvmName("xvumtktjpdxyglym")
    public suspend fun iotHubs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param values IoT Hub resource IDs
     */
    @JvmName("ptnbevdfgagrjlrw")
    public suspend fun iotHubs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.iotHubs = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("jcwjggktlfrgxndo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of the configuration status for each recommendation type.
     */
    @JvmName("xlsexigaclfleqao")
    public suspend
    fun recommendationsConfiguration(`value`: List<RecommendationConfigurationPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationsConfiguration = mapped
    }

    /**
     * @param argument List of the configuration status for each recommendation type.
     */
    @JvmName("khewiymneryspche")
    public suspend
    fun recommendationsConfiguration(argument: List<suspend RecommendationConfigurationPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecommendationConfigurationPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recommendationsConfiguration = mapped
    }

    /**
     * @param argument List of the configuration status for each recommendation type.
     */
    @JvmName("vcsrwgsnilveutgw")
    public suspend fun recommendationsConfiguration(
        vararg
        argument: suspend RecommendationConfigurationPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecommendationConfigurationPropertiesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.recommendationsConfiguration = mapped
    }

    /**
     * @param argument List of the configuration status for each recommendation type.
     */
    @JvmName("llaguiaxvrpqerpy")
    public suspend
    fun recommendationsConfiguration(argument: suspend RecommendationConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RecommendationConfigurationPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.recommendationsConfiguration = mapped
    }

    /**
     * @param values List of the configuration status for each recommendation type.
     */
    @JvmName("irfubujgwfgitswc")
    public suspend fun recommendationsConfiguration(
        vararg
        values: RecommendationConfigurationPropertiesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recommendationsConfiguration = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("nlmvaubnkuipkjmn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT Security solution.
     */
    @JvmName("rybuvqgevjwypfnr")
    public suspend fun solutionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.solutionName = mapped
    }

    /**
     * @param value Status of the IoT Security solution.
     */
    @JvmName("adtuchennkmibyui")
    public suspend fun status(`value`: Either<String, SecuritySolutionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the IoT Security solution.
     */
    @JvmName("qnwyeresfexrsfny")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecuritySolutionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Status of the IoT Security solution.
     */
    @JvmName("ffgicgbespeayhih")
    public fun status(`value`: SecuritySolutionStatus) {
        val toBeMapped = Either.ofRight<String, SecuritySolutionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("brdeexpaivhefecp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("ipisfsuodeyhgiuu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Unmasked IP address logging status
     */
    @JvmName("hqidlkbvhhosvuiv")
    public suspend fun unmaskedIpLoggingStatus(`value`: Either<String, UnmaskedIpLoggingStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unmaskedIpLoggingStatus = mapped
    }

    /**
     * @param value Unmasked IP address logging status
     */
    @JvmName("oaxnnqxflmsdexhb")
    public fun unmaskedIpLoggingStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UnmaskedIpLoggingStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unmaskedIpLoggingStatus = mapped
    }

    /**
     * @param value Unmasked IP address logging status
     */
    @JvmName("ajfwarkmcbxmyauv")
    public fun unmaskedIpLoggingStatus(`value`: UnmaskedIpLoggingStatus) {
        val toBeMapped = Either.ofRight<String, UnmaskedIpLoggingStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unmaskedIpLoggingStatus = mapped
    }

    /**
     * @param value Properties of the IoT Security solution's user defined resources.
     */
    @JvmName("ftxshbwleqpinytr")
    public suspend fun userDefinedResources(`value`: UserDefinedResourcesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefinedResources = mapped
    }

    /**
     * @param argument Properties of the IoT Security solution's user defined resources.
     */
    @JvmName("hglbobrjhuludgwu")
    public suspend
    fun userDefinedResources(argument: suspend UserDefinedResourcesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = UserDefinedResourcesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userDefinedResources = mapped
    }

    /**
     * @param value Workspace resource ID
     */
    @JvmName("xyrsjvkhmqmcxgjd")
    public suspend fun workspace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspace = mapped
    }

    internal fun build(): IotSecuritySolutionArgs = IotSecuritySolutionArgs(
        additionalWorkspaces = additionalWorkspaces,
        disabledDataSources = disabledDataSources,
        displayName = displayName,
        export = export,
        iotHubs = iotHubs,
        location = location,
        recommendationsConfiguration = recommendationsConfiguration,
        resourceGroupName = resourceGroupName,
        solutionName = solutionName,
        status = status,
        tags = tags,
        unmaskedIpLoggingStatus = unmaskedIpLoggingStatus,
        userDefinedResources = userDefinedResources,
        workspace = workspace,
    )
}
