@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessPolicyVirtualMachineResponse
import com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessRequestResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessPolicyVirtualMachineResponse.Companion.toKotlin as jitNetworkAccessPolicyVirtualMachineResponseToKotlin
import com.pulumi.azurenative.security.kotlin.outputs.JitNetworkAccessRequestResponse.Companion.toKotlin as jitNetworkAccessRequestResponseToKotlin

/**
 * Builder for [JitNetworkAccessPolicy].
 */
@PulumiTagMarker
public class JitNetworkAccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JitNetworkAccessPolicyArgs = JitNetworkAccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JitNetworkAccessPolicyArgsBuilder.() -> Unit) {
        val builder = JitNetworkAccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JitNetworkAccessPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.security.JitNetworkAccessPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return JitNetworkAccessPolicy(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2020-01-01. Prior API version in Azure Native 1.x: 2020-01-01.
 * ## Example Usage
 * ### Create JIT network access policy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jitNetworkAccessPolicy = new AzureNative.Security.JitNetworkAccessPolicy("jitNetworkAccessPolicy", new()
 *     {
 *         AscLocation = "westeurope",
 *         JitNetworkAccessPolicyName = "default",
 *         Kind = "Basic",
 *         Requests = new[]
 *         {
 *             new AzureNative.Security.Inputs.JitNetworkAccessRequestArgs
 *             {
 *                 Requestor = "barbara@contoso.com",
 *                 StartTimeUtc = "2018-05-17T08:06:45.5691611Z",
 *                 VirtualMachines = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.JitNetworkAccessRequestVirtualMachineArgs
 *                     {
 *                         Id = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
 *                         Ports = new[]
 *                         {
 *                             new AzureNative.Security.Inputs.JitNetworkAccessRequestPortArgs
 *                             {
 *                                 AllowedSourceAddressPrefix = "192.127.0.2",
 *                                 EndTimeUtc = "2018-05-17T09:06:45.5691611Z",
 *                                 Number = 3389,
 *                                 Status = "Initiated",
 *                                 StatusReason = "UserRequested",
 *                             },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myRg1",
 *         VirtualMachines = new[]
 *         {
 *             new AzureNative.Security.Inputs.JitNetworkAccessPolicyVirtualMachineArgs
 *             {
 *                 Id = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1",
 *                 Ports = new[]
 *                 {
 *                     new AzureNative.Security.Inputs.JitNetworkAccessPortRuleArgs
 *                     {
 *                         AllowedSourceAddressPrefix = "*",
 *                         MaxRequestAccessDuration = "PT3H",
 *                         Number = 22,
 *                         Protocol = "*",
 *                     },
 *                     new AzureNative.Security.Inputs.JitNetworkAccessPortRuleArgs
 *                     {
 *                         AllowedSourceAddressPrefix = "*",
 *                         MaxRequestAccessDuration = "PT3H",
 *                         Number = 3389,
 *                         Protocol = "*",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewJitNetworkAccessPolicy(ctx, "jitNetworkAccessPolicy", &security.JitNetworkAccessPolicyArgs{
 * 			AscLocation:                pulumi.String("westeurope"),
 * 			JitNetworkAccessPolicyName: pulumi.String("default"),
 * 			Kind:                       pulumi.String("Basic"),
 * 			Requests: []security.JitNetworkAccessRequestArgs{
 * 				{
 * 					Requestor:    pulumi.String("barbara@contoso.com"),
 * 					StartTimeUtc: pulumi.String("2018-05-17T08:06:45.5691611Z"),
 * 					VirtualMachines: security.JitNetworkAccessRequestVirtualMachineArray{
 * 						{
 * 							Id: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 							Ports: security.JitNetworkAccessRequestPortArray{
 * 								{
 * 									AllowedSourceAddressPrefix: pulumi.String("192.127.0.2"),
 * 									EndTimeUtc:                 pulumi.String("2018-05-17T09:06:45.5691611Z"),
 * 									Number:                     pulumi.Int(3389),
 * 									Status:                     pulumi.String("Initiated"),
 * 									StatusReason:               pulumi.String("UserRequested"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myRg1"),
 * 			VirtualMachines: []security.JitNetworkAccessPolicyVirtualMachineArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 * 					Ports: security.JitNetworkAccessPortRuleArray{
 * 						{
 * 							AllowedSourceAddressPrefix: pulumi.String("*"),
 * 							MaxRequestAccessDuration:   pulumi.String("PT3H"),
 * 							Number:                     pulumi.Int(22),
 * 							Protocol:                   pulumi.String("*"),
 * 						},
 * 						{
 * 							AllowedSourceAddressPrefix: pulumi.String("*"),
 * 							MaxRequestAccessDuration:   pulumi.String("PT3H"),
 * 							Number:                     pulumi.Int(3389),
 * 							Protocol:                   pulumi.String("*"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.JitNetworkAccessPolicy;
 * import com.pulumi.azurenative.security.JitNetworkAccessPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jitNetworkAccessPolicy = new JitNetworkAccessPolicy("jitNetworkAccessPolicy", JitNetworkAccessPolicyArgs.builder()
 *             .ascLocation("westeurope")
 *             .jitNetworkAccessPolicyName("default")
 *             .kind("Basic")
 *             .requests(Map.ofEntries(
 *                 Map.entry("requestor", "barbara@contoso.com"),
 *                 Map.entry("startTimeUtc", "2018-05-17T08:06:45.5691611Z"),
 *                 Map.entry("virtualMachines", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 *                     Map.entry("ports", Map.ofEntries(
 *                         Map.entry("allowedSourceAddressPrefix", "192.127.0.2"),
 *                         Map.entry("endTimeUtc", "2018-05-17T09:06:45.5691611Z"),
 *                         Map.entry("number", 3389),
 *                         Map.entry("status", "Initiated"),
 *                         Map.entry("statusReason", "UserRequested")
 *                     ))
 *                 ))
 *             ))
 *             .resourceGroupName("myRg1")
 *             .virtualMachines(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg1/providers/Microsoft.Compute/virtualMachines/vm1"),
 *                 Map.entry("ports",
 *                     Map.ofEntries(
 *                         Map.entry("allowedSourceAddressPrefix", "*"),
 *                         Map.entry("maxRequestAccessDuration", "PT3H"),
 *                         Map.entry("number", 22),
 *                         Map.entry("protocol", "*")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("allowedSourceAddressPrefix", "*"),
 *                         Map.entry("maxRequestAccessDuration", "PT3H"),
 *                         Map.entry("number", 3389),
 *                         Map.entry("protocol", "*")
 *                     ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:JitNetworkAccessPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}
 * ```
 */
public class JitNetworkAccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.security.JitNetworkAccessPolicy,
) : KotlinCustomResource(javaResource, JitNetworkAccessPolicyMapper) {
    /**
     * Kind of the resource
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Location where the resource is stored
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets the provisioning state of the Just-in-Time policy.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    public val requests: Output<List<JitNetworkAccessRequestResponse>>?
        get() = javaResource.requests().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> jitNetworkAccessRequestResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Configurations for Microsoft.Compute/virtualMachines resource type.
     */
    public val virtualMachines: Output<List<JitNetworkAccessPolicyVirtualMachineResponse>>
        get() = javaResource.virtualMachines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jitNetworkAccessPolicyVirtualMachineResponseToKotlin(args0) })
            })
        })
}

public object JitNetworkAccessPolicyMapper : ResourceMapper<JitNetworkAccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.JitNetworkAccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): JitNetworkAccessPolicy =
        JitNetworkAccessPolicy(javaResource as com.pulumi.azurenative.security.JitNetworkAccessPolicy)
}

/**
 * @see [JitNetworkAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JitNetworkAccessPolicy].
 */
public suspend fun jitNetworkAccessPolicy(
    name: String,
    block: suspend JitNetworkAccessPolicyResourceBuilder.() -> Unit,
): JitNetworkAccessPolicy {
    val builder = JitNetworkAccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JitNetworkAccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jitNetworkAccessPolicy(name: String): JitNetworkAccessPolicy {
    val builder = JitNetworkAccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
