@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.security.kotlin.outputs.IdentityResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SecurityOperator].
 */
@PulumiTagMarker
public class SecurityOperatorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecurityOperatorArgs = SecurityOperatorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecurityOperatorArgsBuilder.() -> Unit) {
        val builder = SecurityOperatorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SecurityOperator {
        val builtJavaResource =
            com.pulumi.azurenative.security.SecurityOperator(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecurityOperator(builtJavaResource)
    }
}

/**
 * Security operator under a given subscription and pricing
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### Create a security operator on the given scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityOperator = new AzureNative.Security.SecurityOperator("securityOperator", new()
 *     {
 *         PricingName = "CloudPosture",
 *         SecurityOperatorName = "DefenderCSPMSecurityOperator",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityOperator(ctx, "securityOperator", &security.SecurityOperatorArgs{
 * 			PricingName:          pulumi.String("CloudPosture"),
 * 			SecurityOperatorName: pulumi.String("DefenderCSPMSecurityOperator"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityOperator;
 * import com.pulumi.azurenative.security.SecurityOperatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityOperator = new SecurityOperator("securityOperator", SecurityOperatorArgs.builder()
 *             .pricingName("CloudPosture")
 *             .securityOperatorName("DefenderCSPMSecurityOperator")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityOperator DefenderCSPMSecurityOperator /subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}
 * ```
 */
public class SecurityOperator internal constructor(
    override val javaResource: com.pulumi.azurenative.security.SecurityOperator,
) : KotlinCustomResource(javaResource, SecurityOperatorMapper) {
    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SecurityOperatorMapper : ResourceMapper<SecurityOperator> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.SecurityOperator::class == javaResource::class

    override fun map(javaResource: Resource): SecurityOperator = SecurityOperator(
        javaResource as
            com.pulumi.azurenative.security.SecurityOperator,
    )
}

/**
 * @see [SecurityOperator].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecurityOperator].
 */
public suspend fun securityOperator(
    name: String,
    block: suspend SecurityOperatorResourceBuilder.() -> Unit,
): SecurityOperator {
    val builder = SecurityOperatorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecurityOperator].
 * @param name The _unique_ name of the resulting resource.
 */
public fun securityOperator(name: String): SecurityOperator {
    val builder = SecurityOperatorResourceBuilder()
    builder.name(name)
    return builder.build()
}
