@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SecurityOperatorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Security operator under a given subscription and pricing
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### Create a security operator on the given scope
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityOperator = new AzureNative.Security.SecurityOperator("securityOperator", new()
 *     {
 *         PricingName = "CloudPosture",
 *         SecurityOperatorName = "DefenderCSPMSecurityOperator",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityOperator(ctx, "securityOperator", &security.SecurityOperatorArgs{
 * 			PricingName:          pulumi.String("CloudPosture"),
 * 			SecurityOperatorName: pulumi.String("DefenderCSPMSecurityOperator"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityOperator;
 * import com.pulumi.azurenative.security.SecurityOperatorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityOperator = new SecurityOperator("securityOperator", SecurityOperatorArgs.builder()
 *             .pricingName("CloudPosture")
 *             .securityOperatorName("DefenderCSPMSecurityOperator")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityOperator DefenderCSPMSecurityOperator /subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}
 * ```
 * @property pricingName name of the pricing configuration
 * @property securityOperatorName name of the securityOperator
 */
public data class SecurityOperatorArgs(
    public val pricingName: Output<String>? = null,
    public val securityOperatorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.SecurityOperatorArgs> {
    override fun toJava(): com.pulumi.azurenative.security.SecurityOperatorArgs =
        com.pulumi.azurenative.security.SecurityOperatorArgs.builder()
            .pricingName(pricingName?.applyValue({ args0 -> args0 }))
            .securityOperatorName(securityOperatorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityOperatorArgs].
 */
@PulumiTagMarker
public class SecurityOperatorArgsBuilder internal constructor() {
    private var pricingName: Output<String>? = null

    private var securityOperatorName: Output<String>? = null

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("gtkxohqlwacfwypq")
    public suspend fun pricingName(`value`: Output<String>) {
        this.pricingName = value
    }

    /**
     * @param value name of the securityOperator
     */
    @JvmName("qnmvestbtciuyuhx")
    public suspend fun securityOperatorName(`value`: Output<String>) {
        this.securityOperatorName = value
    }

    /**
     * @param value name of the pricing configuration
     */
    @JvmName("cyweuqhlrjuxdyvn")
    public suspend fun pricingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pricingName = mapped
    }

    /**
     * @param value name of the securityOperator
     */
    @JvmName("rnxcyoihfipetyun")
    public suspend fun securityOperatorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityOperatorName = mapped
    }

    internal fun build(): SecurityOperatorArgs = SecurityOperatorArgs(
        pricingName = pricingName,
        securityOperatorName = securityOperatorName,
    )
}
