@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The application source, what it affects, e.g. Assessments
 */
public enum class ApplicationSourceResourceType(
    public val javaValue: com.pulumi.azurenative.security.enums.ApplicationSourceResourceType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.ApplicationSourceResourceType> {
    /**
     * The source of the application is assessments
     */
    Assessments(com.pulumi.azurenative.security.enums.ApplicationSourceResourceType.Assessments),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.ApplicationSourceResourceType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.enums.ApplicationSourceResourceType):
            ApplicationSourceResourceType =
            ApplicationSourceResourceType.values().first { it.javaValue == javaType }
    }
}
