@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * BuiltIn if the assessment based on built-in Azure Policy definition, Custom if the assessment based on custom Azure Policy definition
 */
public enum class AssessmentType(
    public val javaValue: com.pulumi.azurenative.security.enums.AssessmentType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.AssessmentType> {
    /**
     * Microsoft Defender for Cloud managed assessments
     */
    BuiltIn(com.pulumi.azurenative.security.enums.AssessmentType.BuiltIn),

    /**
     * User defined policies that are automatically ingested from Azure Policy to Microsoft Defender for Cloud
     */
    CustomPolicy(com.pulumi.azurenative.security.enums.AssessmentType.CustomPolicy),

    /**
     * User assessments pushed directly by the user or other third party to Microsoft Defender for Cloud
     */
    CustomerManaged(com.pulumi.azurenative.security.enums.AssessmentType.CustomerManaged),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.AssessmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.AssessmentType):
            AssessmentType = AssessmentType.values().first { it.javaValue == javaType }
    }
}
