@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The owner type for the governance rule owner source
 */
public enum class GovernanceRuleOwnerSourceType(
    public val javaValue: com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType> {
    /**
     * The rule source type defined using resource tag
     */
    ByTag(com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType.ByTag),

    /**
     * The rule source type defined manually
     */
    Manually(com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType.Manually),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.enums.GovernanceRuleOwnerSourceType):
            GovernanceRuleOwnerSourceType =
            GovernanceRuleOwnerSourceType.values().first { it.javaValue == javaType }
    }
}
