@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of the port
 */
public enum class Status(
    public val javaValue: com.pulumi.azurenative.security.enums.Status,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Status> {
    Revoked(com.pulumi.azurenative.security.enums.Status.Revoked),
    Initiated(com.pulumi.azurenative.security.enums.Status.Initiated),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Status = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Status): Status =
            Status.values().first { it.javaValue == javaType }
    }
}
