@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AssessmentStatusArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AssessmentStatusCode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The result of the assessment
 * @property cause Programmatic code for the cause of the assessment status
 * @property code Programmatic code for the status of the assessment
 * @property description Human readable description of the assessment status
 */
public data class AssessmentStatusArgs(
    public val cause: Output<String>? = null,
    public val code: Output<Either<String, AssessmentStatusCode>>,
    public val description: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AssessmentStatusArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AssessmentStatusArgs =
        com.pulumi.azurenative.security.inputs.AssessmentStatusArgs.builder()
            .cause(cause?.applyValue({ args0 -> args0 }))
            .code(
                code.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentStatusArgs].
 */
@PulumiTagMarker
public class AssessmentStatusArgsBuilder internal constructor() {
    private var cause: Output<String>? = null

    private var code: Output<Either<String, AssessmentStatusCode>>? = null

    private var description: Output<String>? = null

    /**
     * @param value Programmatic code for the cause of the assessment status
     */
    @JvmName("sxorijvjtgctrghr")
    public suspend fun cause(`value`: Output<String>) {
        this.cause = value
    }

    /**
     * @param value Programmatic code for the status of the assessment
     */
    @JvmName("klwxpvecdffqrowu")
    public suspend fun code(`value`: Output<Either<String, AssessmentStatusCode>>) {
        this.code = value
    }

    /**
     * @param value Human readable description of the assessment status
     */
    @JvmName("iisxyrrmxahaygnn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Programmatic code for the cause of the assessment status
     */
    @JvmName("hmcmidpkrbavrvnr")
    public suspend fun cause(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cause = mapped
    }

    /**
     * @param value Programmatic code for the status of the assessment
     */
    @JvmName("eykjepjcfxbydtlm")
    public suspend fun code(`value`: Either<String, AssessmentStatusCode>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Programmatic code for the status of the assessment
     */
    @JvmName("cibotvmydgnqofee")
    public fun code(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AssessmentStatusCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Programmatic code for the status of the assessment
     */
    @JvmName("qdosrciriknkkdvg")
    public fun code(`value`: AssessmentStatusCode) {
        val toBeMapped = Either.ofRight<String, AssessmentStatusCode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.code = mapped
    }

    /**
     * @param value Human readable description of the assessment status
     */
    @JvmName("ulridrtrmhoxqdnw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    internal fun build(): AssessmentStatusArgs = AssessmentStatusArgs(
        cause = cause,
        code = code ?: throw PulumiNullFieldException("code"),
        description = description,
    )
}
