@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Additional data about the assignment
 * @property exemptionCategory Exemption category of this assignment
 */
public data class AssignmentPropertiesAdditionalDataArgs(
    public val exemptionCategory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs =
        com.pulumi.azurenative.security.inputs.AssignmentPropertiesAdditionalDataArgs.builder()
            .exemptionCategory(exemptionCategory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignmentPropertiesAdditionalDataArgs].
 */
@PulumiTagMarker
public class AssignmentPropertiesAdditionalDataArgsBuilder internal constructor() {
    private var exemptionCategory: Output<String>? = null

    /**
     * @param value Exemption category of this assignment
     */
    @JvmName("mypeyjulhqkjtokn")
    public suspend fun exemptionCategory(`value`: Output<String>) {
        this.exemptionCategory = value
    }

    /**
     * @param value Exemption category of this assignment
     */
    @JvmName("vjqpyxxoogqerdxg")
    public suspend fun exemptionCategory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exemptionCategory = mapped
    }

    internal fun build(): AssignmentPropertiesAdditionalDataArgs =
        AssignmentPropertiesAdditionalDataArgs(
            exemptionCategory = exemptionCategory,
        )
}
