@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AuthorizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization payload.
 * @property code Gets or sets one-time OAuth code to exchange for refresh and access tokens.
 * Only used during PUT/PATCH operations. The secret is cleared during GET.
 */
public data class AuthorizationArgs(
    public val code: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AuthorizationArgs =
        com.pulumi.azurenative.security.inputs.AuthorizationArgs.builder()
            .code(code?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthorizationArgs].
 */
@PulumiTagMarker
public class AuthorizationArgsBuilder internal constructor() {
    private var code: Output<String>? = null

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT/PATCH operations. The secret is cleared during GET.
     */
    @JvmName("gbdmvsjdsyowysnq")
    public suspend fun code(`value`: Output<String>) {
        this.code = value
    }

    /**
     * @param value Gets or sets one-time OAuth code to exchange for refresh and access tokens.
     * Only used during PUT/PATCH operations. The secret is cleared during GET.
     */
    @JvmName("wggeoxpwyfacgsmo")
    public suspend fun code(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.code = mapped
    }

    internal fun build(): AuthorizationArgs = AuthorizationArgs(
        code = code,
    )
}
