@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationActionLogicAppArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The logic app action that should be triggered. To learn more about Microsoft Defender for Cloud's Workflow Automation capabilities, visit https://aka.ms/ASCWorkflowAutomationLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'LogicApp'.
 * @property logicAppResourceId The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
 * @property uri The Logic App trigger URI endpoint (it will not be included in any response).
 */
public data class AutomationActionLogicAppArgs(
    public val actionType: Output<String>,
    public val logicAppResourceId: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationActionLogicAppArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationActionLogicAppArgs =
        com.pulumi.azurenative.security.inputs.AutomationActionLogicAppArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .logicAppResourceId(logicAppResourceId?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationActionLogicAppArgs].
 */
@PulumiTagMarker
public class AutomationActionLogicAppArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var logicAppResourceId: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'LogicApp'.
     */
    @JvmName("fpblqtmbtaythrsj")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
     */
    @JvmName("asokvchuulealwpu")
    public suspend fun logicAppResourceId(`value`: Output<String>) {
        this.logicAppResourceId = value
    }

    /**
     * @param value The Logic App trigger URI endpoint (it will not be included in any response).
     */
    @JvmName("fuuwqrrkdlshmglr")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'LogicApp'.
     */
    @JvmName("essppyhqrsprmdqq")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The triggered Logic App Azure Resource ID. This can also reside on other subscriptions, given that you have permissions to trigger the Logic App
     */
    @JvmName("wjctrgingibncwvd")
    public suspend fun logicAppResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logicAppResourceId = mapped
    }

    /**
     * @param value The Logic App trigger URI endpoint (it will not be included in any response).
     */
    @JvmName("qwmjllmkvdfdrdtg")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): AutomationActionLogicAppArgs = AutomationActionLogicAppArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        logicAppResourceId = logicAppResourceId,
        uri = uri,
    )
}
