@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A single automation scope.
 * @property description The resources scope description.
 * @property scopePath The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
 */
public data class AutomationScopeArgs(
    public val description: Output<String>? = null,
    public val scopePath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationScopeArgs =
        com.pulumi.azurenative.security.inputs.AutomationScopeArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .scopePath(scopePath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationScopeArgs].
 */
@PulumiTagMarker
public class AutomationScopeArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var scopePath: Output<String>? = null

    /**
     * @param value The resources scope description.
     */
    @JvmName("ykfjqmmwmyhvgeoi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
     */
    @JvmName("qjciawxwmlinfhih")
    public suspend fun scopePath(`value`: Output<String>) {
        this.scopePath = value
    }

    /**
     * @param value The resources scope description.
     */
    @JvmName("nhsaejrfhraqulux")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The resources scope path. Can be the subscription on which the automation is defined on or a resource group under that subscription (fully qualified Azure resource IDs).
     */
    @JvmName("gncykstuuinwemyc")
    public suspend fun scopePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopePath = mapped
    }

    internal fun build(): AutomationScopeArgs = AutomationScopeArgs(
        description = description,
        scopePath = scopePath,
    )
}
